package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.impl.CloneNodeCommand;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public class Marshaller_o_k_w_c_s_c_g_c_i_CloneNodeCommand_1_Impl implements GeneratedMarshaller<CloneNodeCommand> {
  private CloneNodeCommand[] EMPTY_ARRAY = new CloneNodeCommand[0];
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Optional> java_util_Optional = Marshalling.getMarshaller(Optional.class);
  private Marshaller<Point2D> org_kie_workbench_common_stunner_core_graph_content_view_Point2D = null;
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public CloneNodeCommand[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Optional CloneNodeCommand_Optional_parentUuidOptional(CloneNodeCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.command.impl.CloneNodeCommand::parentUuidOptional;
  }-*/;

  native static void CloneNodeCommand_Optional_parentUuidOptional(CloneNodeCommand instance, Optional<String> value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.command.impl.CloneNodeCommand::parentUuidOptional = value;
  }-*/;

  native static Point2D CloneNodeCommand_Point2D_position(CloneNodeCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.command.impl.CloneNodeCommand::position;
  }-*/;

  native static void CloneNodeCommand_Point2D_position(CloneNodeCommand instance, Point2D value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.command.impl.CloneNodeCommand::position = value;
  }-*/;

  native static List AbstractCompositeCommand_List_commands(AbstractCompositeCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand::commands;
  }-*/;

  native static void AbstractCompositeCommand_List_commands(AbstractCompositeCommand instance, List<Command<GraphCommandExecutionContext, RuleViolation>> value) /*-{
    instance.@org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand::commands = value;
  }-*/;

  native static boolean AbstractCompositeCommand_boolean_initialized(AbstractCompositeCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand::initialized;
  }-*/;

  native static void AbstractCompositeCommand_boolean_initialized(AbstractCompositeCommand instance, boolean value) /*-{
    instance.@org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand::initialized = value;
  }-*/;

  public CloneNodeCommand demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(CloneNodeCommand.class, objId);
    }
    final Node c0 = (Node) ((ObjectMarshaller) java_lang_Object).demarshall(Node.class, obj.get("candidate"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("parentUuid"), a1);
    CloneNodeCommand entity = new CloneNodeCommand(c0, c1);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "parentUuidOptional": CloneNodeCommand_Optional_parentUuidOptional(entity, java_util_Optional.demarshall(objVal, a1));
        break;
        case "position": CloneNodeCommand_Point2D_position(entity, org_kie_workbench_common_stunner_core_graph_content_view_Point2D.demarshall(objVal, a1));
        break;
        case "commands": a1.setAssumedElementType("org.kie.workbench.common.stunner.core.command.Command");
        AbstractCompositeCommand_List_commands(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "initialized": AbstractCompositeCommand_boolean_initialized(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(CloneNodeCommand a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.graph.command.impl.CloneNodeCommand") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "candidate") + "\":") + java_lang_Object.marshall(a0.getCandidate(), a1)) + ",\"") + "parentUuidOptional") + "\":") + java_util_Optional.marshall(CloneNodeCommand_Optional_parentUuidOptional(a0), a1)) + ",\"") + "position") + "\":") + org_kie_workbench_common_stunner_core_graph_content_view_Point2D.marshall(CloneNodeCommand_Point2D_position(a0), a1)) + ",\"") + "commands") + "\":") + java_util_List.marshall(a0.getCommands(), a1)) + ",\"") + "initialized") + "\":") + java_lang_Boolean.marshall(AbstractCompositeCommand_boolean_initialized(a0), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_stunner_core_graph_content_view_Point2D == null) {
      org_kie_workbench_common_stunner_core_graph_content_view_Point2D = Marshalling.getMarshaller(Point2D.class);
    }
  }
}