package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.core.graph.command.impl.DockNodeCommand;

public class Marshaller_o_k_w_c_s_c_g_c_i_DockNodeCommand_1_Impl implements GeneratedMarshaller<DockNodeCommand> {
  private DockNodeCommand[] EMPTY_ARRAY = new DockNodeCommand[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public DockNodeCommand[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String DockNodeCommand_String_parentUUID(DockNodeCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.command.impl.DockNodeCommand::parentUUID;
  }-*/;

  native static void DockNodeCommand_String_parentUUID(DockNodeCommand instance, String value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.command.impl.DockNodeCommand::parentUUID = value;
  }-*/;

  native static String DockNodeCommand_String_candidateUUID(DockNodeCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.command.impl.DockNodeCommand::candidateUUID;
  }-*/;

  native static void DockNodeCommand_String_candidateUUID(DockNodeCommand instance, String value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.command.impl.DockNodeCommand::candidateUUID = value;
  }-*/;

  public DockNodeCommand demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DockNodeCommand.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("parentUUID"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("candidate"), a1);
    DockNodeCommand entity = new DockNodeCommand(c0, c1);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "parentUUID": DockNodeCommand_String_parentUUID(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "candidateUUID": DockNodeCommand_String_candidateUUID(entity, java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DockNodeCommand a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.graph.command.impl.DockNodeCommand") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "parentUUID") + "\":") + java_lang_String.marshall(DockNodeCommand_String_parentUUID(a0), a1)) + ",\"") + "candidateUUID") + "\":") + java_lang_String.marshall(DockNodeCommand_String_candidateUUID(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}