package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.graph.command.impl.MorphNodeCommand;

public class Marshaller_o_k_w_c_s_c_g_c_i_MorphNodeCommand_1_Impl implements GeneratedMarshaller<MorphNodeCommand> {
  private MorphNodeCommand[] EMPTY_ARRAY = new MorphNodeCommand[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public MorphNodeCommand[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String MorphNodeCommand_String_uuid(MorphNodeCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.command.impl.MorphNodeCommand::uuid;
  }-*/;

  native static void MorphNodeCommand_String_uuid(MorphNodeCommand instance, String value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.command.impl.MorphNodeCommand::uuid = value;
  }-*/;

  native static MorphDefinition MorphNodeCommand_MorphDefinition_morphDefinition(MorphNodeCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.command.impl.MorphNodeCommand::morphDefinition;
  }-*/;

  native static void MorphNodeCommand_MorphDefinition_morphDefinition(MorphNodeCommand instance, MorphDefinition value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.command.impl.MorphNodeCommand::morphDefinition = value;
  }-*/;

  native static String MorphNodeCommand_String_morphTarget(MorphNodeCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.command.impl.MorphNodeCommand::morphTarget;
  }-*/;

  native static void MorphNodeCommand_String_morphTarget(MorphNodeCommand instance, String value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.command.impl.MorphNodeCommand::morphTarget = value;
  }-*/;

  public MorphNodeCommand demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(MorphNodeCommand.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("uuid"), a1);
    final MorphDefinition c1 = (MorphDefinition) ((ObjectMarshaller) java_lang_Object).demarshall(MorphDefinition.class, obj.get("morphDefinition"), a1);
    final String c2 = java_lang_String.demarshall(obj.get("morphTarget"), a1);
    MorphNodeCommand entity = new MorphNodeCommand(c0, c1, c2);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "uuid": MorphNodeCommand_String_uuid(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "morphDefinition": MorphNodeCommand_MorphDefinition_morphDefinition(entity, (MorphDefinition) ((ObjectMarshaller) java_lang_Object).demarshall(MorphDefinition.class, objVal, a1));
        break;
        case "morphTarget": MorphNodeCommand_String_morphTarget(entity, java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(MorphNodeCommand a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.graph.command.impl.MorphNodeCommand") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "uuid") + "\":") + java_lang_String.marshall(MorphNodeCommand_String_uuid(a0), a1)) + ",\"") + "morphDefinition") + "\":") + java_lang_Object.marshall(MorphNodeCommand_MorphDefinition_morphDefinition(a0), a1)) + ",\"") + "morphTarget") + "\":") + java_lang_String.marshall(MorphNodeCommand_String_morphTarget(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}