package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.core.graph.command.impl.SafeDeleteNodeCommand.Options;

public class Marshaller_o_k_w_c_s_c_g_c_i_SafeDeleteNodeCommand_erraiD_Options_1_Impl implements GeneratedMarshaller<Options> {
  private Options[] EMPTY_ARRAY = new Options[0];
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  public Options[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public Options demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Options.class, objId);
    }
    final Boolean c0 = java_lang_Boolean.demarshall(obj.get("shortcutCandidateConnectors"), a1);
    a1.setAssumedElementType("java.lang.String");
    final Set c1 = java_util_Set.demarshall(obj.get("exclusions"), a1);
    Options entity = new Options(c0, c1);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(Options a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.graph.command.impl.SafeDeleteNodeCommand$Options") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "shortcutCandidateConnectors") + "\":") + java_lang_Boolean.marshall(a0.isShortcutCandidateConnectors(), a1)) + ",\"") + "exclusions") + "\":") + java_util_Set.marshall(a0.getExclusions(), a1)) + "}");
  }

  private void lazyInit() {

  }
}