package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.stunner.core.graph.command.impl.UpdateElementPropertyValueCommand;

public class Marshaller_o_k_w_c_s_c_g_c_i_UpdateElementPropertyValueCommand_1_Impl implements GeneratedMarshaller<UpdateElementPropertyValueCommand> {
  private UpdateElementPropertyValueCommand[] EMPTY_ARRAY = new UpdateElementPropertyValueCommand[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public UpdateElementPropertyValueCommand[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String UpdateElementPropertyValueCommand_String_elementUUID(UpdateElementPropertyValueCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.command.impl.UpdateElementPropertyValueCommand::elementUUID;
  }-*/;

  native static void UpdateElementPropertyValueCommand_String_elementUUID(UpdateElementPropertyValueCommand instance, String value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.command.impl.UpdateElementPropertyValueCommand::elementUUID = value;
  }-*/;

  native static Object UpdateElementPropertyValueCommand_Object_oldValue(UpdateElementPropertyValueCommand instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.command.impl.UpdateElementPropertyValueCommand::oldValue;
  }-*/;

  native static void UpdateElementPropertyValueCommand_Object_oldValue(UpdateElementPropertyValueCommand instance, Object value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.command.impl.UpdateElementPropertyValueCommand::oldValue = value;
  }-*/;

  public UpdateElementPropertyValueCommand demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(UpdateElementPropertyValueCommand.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("elementUUID"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("propertyId"), a1);
    final Object c2 = ((ObjectMarshaller) java_lang_Object).demarshall(Object.class, obj.get("value"), a1);
    UpdateElementPropertyValueCommand entity = new UpdateElementPropertyValueCommand(c0, c1, c2);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "elementUUID": UpdateElementPropertyValueCommand_String_elementUUID(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "oldValue": UpdateElementPropertyValueCommand_Object_oldValue(entity, ((ObjectMarshaller) java_lang_Object).demarshall(Object.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(UpdateElementPropertyValueCommand a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.graph.command.impl.UpdateElementPropertyValueCommand") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "elementUUID") + "\":") + java_lang_String.marshall(UpdateElementPropertyValueCommand_String_elementUUID(a0), a1)) + ",\"") + "propertyId") + "\":") + java_lang_String.marshall(a0.getPropertyId(), a1)) + ",\"") + "value") + "\":") + java_lang_Object.marshall(a0.getValue(), a1)) + ",\"") + "oldValue") + "\":") + java_lang_Object.marshall(a0.getOldValue(), a1)) + "}");
  }

  private void lazyInit() {

  }
}