package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.impl.AbstractElement;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;

public class Marshaller_o_k_w_c_s_c_g_i_EdgeImpl_1_Impl implements GeneratedMarshaller<EdgeImpl> {
  private EdgeImpl[] EMPTY_ARRAY = new EdgeImpl[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  public EdgeImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String AbstractElement_String_uuid(AbstractElement instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.impl.AbstractElement::uuid;
  }-*/;

  native static void AbstractElement_String_uuid(AbstractElement instance, String value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.impl.AbstractElement::uuid = value;
  }-*/;

  native static Set AbstractElement_Set_labels(AbstractElement instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.impl.AbstractElement::labels;
  }-*/;

  native static void AbstractElement_Set_labels(AbstractElement instance, Set<String> value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.impl.AbstractElement::labels = value;
  }-*/;

  public EdgeImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(EdgeImpl.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("uuid"), a1);
    EdgeImpl entity = new EdgeImpl(c0);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "sourceNode": entity.setSourceNode((Node) ((ObjectMarshaller) java_lang_Object).demarshall(Node.class, objVal, a1));
        break;
        case "targetNode": entity.setTargetNode((Node) ((ObjectMarshaller) java_lang_Object).demarshall(Node.class, objVal, a1));
        break;
        case "uuid": AbstractElement_String_uuid(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "labels": a1.setAssumedElementType("java.lang.String");
        AbstractElement_Set_labels(entity, java_util_Set.demarshall(objVal, a1));
        break;
        case "content": entity.setContent(((ObjectMarshaller) java_lang_Object).demarshall(Object.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(EdgeImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "sourceNode") + "\":") + java_lang_Object.marshall(a0.getSourceNode(), a1)) + ",\"") + "targetNode") + "\":") + java_lang_Object.marshall(a0.getTargetNode(), a1)) + ",\"") + "uuid") + "\":") + java_lang_String.marshall(a0.getUUID(), a1)) + ",\"") + "labels") + "\":") + java_util_Set.marshall(a0.getLabels(), a1)) + ",\"") + "content") + "\":") + java_lang_Object.marshall(a0.getContent(), a1)) + "}");
  }

  private void lazyInit() {

  }
}