package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.impl.AbstractElement;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;

public class Marshaller_o_k_w_c_s_c_g_i_NodeImpl_1_Impl implements GeneratedMarshaller<NodeImpl> {
  private NodeImpl[] EMPTY_ARRAY = new NodeImpl[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public NodeImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static List NodeImpl_List_inEdges(NodeImpl instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.impl.NodeImpl::inEdges;
  }-*/;

  native static void NodeImpl_List_inEdges(NodeImpl instance, List<Edge> value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.impl.NodeImpl::inEdges = value;
  }-*/;

  native static List NodeImpl_List_outEdges(NodeImpl instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.impl.NodeImpl::outEdges;
  }-*/;

  native static void NodeImpl_List_outEdges(NodeImpl instance, List<Edge> value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.impl.NodeImpl::outEdges = value;
  }-*/;

  native static String AbstractElement_String_uuid(AbstractElement instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.impl.AbstractElement::uuid;
  }-*/;

  native static void AbstractElement_String_uuid(AbstractElement instance, String value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.impl.AbstractElement::uuid = value;
  }-*/;

  native static Set AbstractElement_Set_labels(AbstractElement instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.impl.AbstractElement::labels;
  }-*/;

  native static void AbstractElement_Set_labels(AbstractElement instance, Set<String> value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.impl.AbstractElement::labels = value;
  }-*/;

  public NodeImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(NodeImpl.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("uuid"), a1);
    NodeImpl entity = new NodeImpl(c0);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "inEdges": a1.setAssumedElementType("org.kie.workbench.common.stunner.core.graph.Edge");
        NodeImpl_List_inEdges(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "outEdges": a1.setAssumedElementType("org.kie.workbench.common.stunner.core.graph.Edge");
        NodeImpl_List_outEdges(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "uuid": AbstractElement_String_uuid(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "labels": a1.setAssumedElementType("java.lang.String");
        AbstractElement_Set_labels(entity, java_util_Set.demarshall(objVal, a1));
        break;
        case "content": entity.setContent(((ObjectMarshaller) java_lang_Object).demarshall(Object.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(NodeImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.graph.impl.NodeImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "inEdges") + "\":") + java_util_List.marshall(a0.getInEdges(), a1)) + ",\"") + "outEdges") + "\":") + java_util_List.marshall(a0.getOutEdges(), a1)) + ",\"") + "uuid") + "\":") + java_lang_String.marshall(a0.getUUID(), a1)) + ",\"") + "labels") + "\":") + java_util_Set.marshall(a0.getLabels(), a1)) + ",\"") + "content") + "\":") + java_lang_Object.marshall(a0.getContent(), a1)) + "}");
  }

  private void lazyInit() {

  }
}