package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStoreImpl;

public class Marshaller_o_k_w_c_s_c_g_s_GraphNodeStoreImpl_1_Impl implements GeneratedMarshaller<GraphNodeStoreImpl> {
  private GraphNodeStoreImpl[] EMPTY_ARRAY = new GraphNodeStoreImpl[0];
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  public GraphNodeStoreImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Map GraphNodeStoreImpl_Map_nodes(GraphNodeStoreImpl instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.graph.store.GraphNodeStoreImpl::nodes;
  }-*/;

  native static void GraphNodeStoreImpl_Map_nodes(GraphNodeStoreImpl instance, Map<String, Node> value) /*-{
    instance.@org.kie.workbench.common.stunner.core.graph.store.GraphNodeStoreImpl::nodes = value;
  }-*/;

  public GraphNodeStoreImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(GraphNodeStoreImpl.class, objId);
    }
    GraphNodeStoreImpl entity = new GraphNodeStoreImpl();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "nodes": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("org.kie.workbench.common.stunner.core.graph.Node");
        GraphNodeStoreImpl_Map_nodes(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
      }
    }
    return entity;
  }

  public String marshall(GraphNodeStoreImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.graph.store.GraphNodeStoreImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "nodes") + "\":") + java_util_Map.marshall(GraphNodeStoreImpl_Map_nodes(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}