package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.core.lookup.LookupResponseImpl;

public class Marshaller_o_k_w_c_s_c_l_LookupResponseImpl_1_Impl implements GeneratedMarshaller<LookupResponseImpl> {
  private LookupResponseImpl[] EMPTY_ARRAY = new LookupResponseImpl[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public LookupResponseImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static boolean LookupResponseImpl_boolean_hasNextPage(LookupResponseImpl instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.lookup.LookupResponseImpl::hasNextPage;
  }-*/;

  native static void LookupResponseImpl_boolean_hasNextPage(LookupResponseImpl instance, boolean value) /*-{
    instance.@org.kie.workbench.common.stunner.core.lookup.LookupResponseImpl::hasNextPage = value;
  }-*/;

  public LookupResponseImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(LookupResponseImpl.class, objId);
    }
    final List c0 = java_util_List.demarshall(obj.get("results"), a1);
    final Integer c1 = java_lang_Integer.demarshall(obj.get("total"), a1);
    final Boolean c2 = java_lang_Boolean.demarshall(obj.get("hasNextPage"), a1);
    final String c3 = java_lang_String.demarshall(obj.get("lookupCriteria"), a1);
    final Integer c4 = java_lang_Integer.demarshall(obj.get("page"), a1);
    final Integer c5 = java_lang_Integer.demarshall(obj.get("pageSize"), a1);
    LookupResponseImpl entity = new LookupResponseImpl(c0, c1, c2, c3, c4, c5);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "hasNextPage": LookupResponseImpl_boolean_hasNextPage(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(LookupResponseImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.lookup.LookupResponseImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "results") + "\":") + java_util_List.marshall(a0.getResults(), a1)) + ",\"") + "total") + "\":") + java_lang_Integer.marshall(a0.getTotal(), a1)) + ",\"") + "hasNextPage") + "\":") + java_lang_Boolean.marshall(LookupResponseImpl_boolean_hasNextPage(a0), a1)) + ",\"") + "lookupCriteria") + "\":") + java_lang_String.marshall(a0.getLookupCriteria(), a1)) + ",\"") + "page") + "\":") + java_lang_Integer.marshall(a0.getPage(), a1)) + ",\"") + "pageSize") + "\":") + java_lang_Integer.marshall(a0.getPageSize(), a1)) + "}");
  }

  private void lazyInit() {

  }
}