package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.core.lookup.definition.DefinitionRepresentation;

public class Marshaller_o_k_w_c_s_c_l_d_DefinitionRepresentation_1_Impl implements GeneratedMarshaller<DefinitionRepresentation> {
  private DefinitionRepresentation[] EMPTY_ARRAY = new DefinitionRepresentation[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  public DefinitionRepresentation[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String DefinitionRepresentation_String_id(DefinitionRepresentation instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.lookup.definition.DefinitionRepresentation::id;
  }-*/;

  native static void DefinitionRepresentation_String_id(DefinitionRepresentation instance, String value) /*-{
    instance.@org.kie.workbench.common.stunner.core.lookup.definition.DefinitionRepresentation::id = value;
  }-*/;

  native static boolean DefinitionRepresentation_boolean_isNode(DefinitionRepresentation instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.lookup.definition.DefinitionRepresentation::isNode;
  }-*/;

  native static void DefinitionRepresentation_boolean_isNode(DefinitionRepresentation instance, boolean value) /*-{
    instance.@org.kie.workbench.common.stunner.core.lookup.definition.DefinitionRepresentation::isNode = value;
  }-*/;

  public DefinitionRepresentation demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DefinitionRepresentation.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("id"), a1);
    final Boolean c1 = java_lang_Boolean.demarshall(obj.get("isNode"), a1);
    a1.setAssumedElementType("java.lang.String");
    final Set c2 = java_util_Set.demarshall(obj.get("labels"), a1);
    DefinitionRepresentation entity = new DefinitionRepresentation(c0, c1, c2);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "id": DefinitionRepresentation_String_id(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "isNode": DefinitionRepresentation_boolean_isNode(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DefinitionRepresentation a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.lookup.definition.DefinitionRepresentation") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "id") + "\":") + java_lang_String.marshall(DefinitionRepresentation_String_id(a0), a1)) + ",\"") + "isNode") + "\":") + java_lang_Boolean.marshall(DefinitionRepresentation_boolean_isNode(a0), a1)) + ",\"") + "labels") + "\":") + java_util_Set.marshall(a0.getLabels(), a1)) + "}");
  }

  private void lazyInit() {

  }
}