package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.core.lookup.AbstractLookupRequest;
import org.kie.workbench.common.stunner.core.lookup.rule.RuleLookupRequest;

public class Marshaller_o_k_w_c_s_c_l_r_RuleLookupRequest_1_Impl implements GeneratedMarshaller<RuleLookupRequest> {
  private RuleLookupRequest[] EMPTY_ARRAY = new RuleLookupRequest[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  public RuleLookupRequest[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String AbstractLookupRequest_String_criteria(AbstractLookupRequest instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.lookup.AbstractLookupRequest::criteria;
  }-*/;

  native static void AbstractLookupRequest_String_criteria(AbstractLookupRequest instance, String value) /*-{
    instance.@org.kie.workbench.common.stunner.core.lookup.AbstractLookupRequest::criteria = value;
  }-*/;

  native static int AbstractLookupRequest_int_page(AbstractLookupRequest instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.lookup.AbstractLookupRequest::page;
  }-*/;

  native static void AbstractLookupRequest_int_page(AbstractLookupRequest instance, int value) /*-{
    instance.@org.kie.workbench.common.stunner.core.lookup.AbstractLookupRequest::page = value;
  }-*/;

  native static int AbstractLookupRequest_int_pageSize(AbstractLookupRequest instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.lookup.AbstractLookupRequest::pageSize;
  }-*/;

  native static void AbstractLookupRequest_int_pageSize(AbstractLookupRequest instance, int value) /*-{
    instance.@org.kie.workbench.common.stunner.core.lookup.AbstractLookupRequest::pageSize = value;
  }-*/;

  public RuleLookupRequest demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(RuleLookupRequest.class, objId);
    }
    final String c3 = java_lang_String.demarshall(obj.get("definitionSetId"), a1);
    final String c0 = java_lang_String.demarshall(obj.get("criteria"), a1);
    final Integer c1 = java_lang_Integer.demarshall(obj.get("page"), a1);
    final Integer c2 = java_lang_Integer.demarshall(obj.get("pageSize"), a1);
    RuleLookupRequest entity = new RuleLookupRequest(c0, c1, c2, c3);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "criteria": AbstractLookupRequest_String_criteria(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "page": AbstractLookupRequest_int_page(entity, java_lang_Integer.demarshall(objVal, a1));
        break;
        case "pageSize": AbstractLookupRequest_int_pageSize(entity, java_lang_Integer.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(RuleLookupRequest a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.lookup.rule.RuleLookupRequest") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "definitionSetId") + "\":") + java_lang_String.marshall(a0.getDefinitionSetId(), a1)) + ",\"") + "criteria") + "\":") + java_lang_String.marshall(a0.getCriteria(), a1)) + ",\"") + "page") + "\":") + java_lang_Integer.marshall(a0.getPage(), a1)) + ",\"") + "pageSize") + "\":") + java_lang_Integer.marshall(a0.getPageSize(), a1)) + "}");
  }

  private void lazyInit() {

  }
}