package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage;
import org.kie.workbench.common.stunner.core.validation.Violation.Type;

public class Marshaller_o_k_w_c_s_c_m_MarshallingMessage_1_Impl implements GeneratedMarshaller<MarshallingMessage> {
  private MarshallingMessage[] EMPTY_ARRAY = new MarshallingMessage[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  private Marshaller<Type> org_kie_workbench_common_stunner_core_validation_Violation_erraiD_Type = null;
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public MarshallingMessage[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String MarshallingMessage_String_elementUUID(MarshallingMessage instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage::elementUUID;
  }-*/;

  native static void MarshallingMessage_String_elementUUID(MarshallingMessage instance, String value) /*-{
    instance.@org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage::elementUUID = value;
  }-*/;

  native static Type MarshallingMessage_Type_type(MarshallingMessage instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage::type;
  }-*/;

  native static void MarshallingMessage_Type_type(MarshallingMessage instance, Type value) /*-{
    instance.@org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage::type = value;
  }-*/;

  public MarshallingMessage demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(MarshallingMessage.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("elementUUID"), a1);
    final Integer c1 = java_lang_Integer.demarshall(obj.get("code"), a1);
    final Type c2 = obj.get("type").isObject() != null ? Enum.valueOf(Type.class, obj.get("type").isObject().get("^EnumStringValue").isString().stringValue()) : obj.get("type").isString() != null ? Enum.valueOf(Type.class, obj.get("type").isString().stringValue()) : null;
    final String c3 = java_lang_String.demarshall(obj.get("message"), a1);
    final String c4 = java_lang_String.demarshall(obj.get("messageKey"), a1);
    final List c5 = java_util_List.demarshall(obj.get("messageArguments"), a1);
    MarshallingMessage entity = new MarshallingMessage(c0, c1, c2, c3, c4, c5);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "elementUUID": MarshallingMessage_String_elementUUID(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "type": MarshallingMessage_Type_type(entity, objVal.isObject() != null ? Enum.valueOf(Type.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(Type.class, objVal.isString().stringValue()) : null);
        break;
      }
    }
    return entity;
  }

  public String marshall(MarshallingMessage a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "elementUUID") + "\":") + java_lang_String.marshall(MarshallingMessage_String_elementUUID(a0), a1)) + ",\"") + "code") + "\":") + java_lang_Integer.marshall(a0.getCode(), a1)) + ",\"") + "type") + "\":") + (MarshallingMessage_Type_type(a0) != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.validation.Violation$Type") + "\",\"") + "^EnumStringValue") + "\":\"") + MarshallingMessage_Type_type(a0).name()) + "\"}" : "null")) + ",\"") + "message") + "\":") + java_lang_String.marshall(a0.getMessage(), a1)) + ",\"") + "messageKey") + "\":") + java_lang_String.marshall(a0.getMessageKey(), a1)) + ",\"") + "messageArguments") + "\":") + java_util_List.marshall(a0.getMessageArguments(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_stunner_core_validation_Violation_erraiD_Type == null) {
      org_kie_workbench_common_stunner_core_validation_Violation_erraiD_Type = Marshalling.getMarshaller(Type.class);
    }
  }
}