package org.jboss.errai.marshalling.client.api;

import java.util.Collection;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.stunner.core.rule.RuleSetImpl;

public class Marshaller_o_k_w_c_s_c_r_RuleSetImpl_1_Impl implements GeneratedMarshaller<RuleSetImpl> {
  private RuleSetImpl[] EMPTY_ARRAY = new RuleSetImpl[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public RuleSetImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public RuleSetImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(RuleSetImpl.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("name"), a1);
    final Collection c1 = (Collection) ((ObjectMarshaller) java_lang_Object).demarshall(Collection.class, obj.get("rules"), a1);
    RuleSetImpl entity = new RuleSetImpl(c0, c1);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(RuleSetImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.rule.RuleSetImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "rules") + "\":") + java_lang_Object.marshall(a0.getRules(), a1)) + "}");
  }

  private void lazyInit() {

  }
}