package org.jboss.errai.marshalling.client.api;

import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtension;

public class Marshaller_o_k_w_c_s_c_r_e_RuleExtension_1_Impl implements GeneratedMarshaller<RuleExtension> {
  private RuleExtension[] EMPTY_ARRAY = new RuleExtension[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public RuleExtension[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public RuleExtension demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(RuleExtension.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("name"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("id"), a1);
    RuleExtension entity = new RuleExtension(c0, c1);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(RuleExtension a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.rule.ext.RuleExtension") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "id") + "\":") + java_lang_String.marshall(a0.getId(), a1)) + "}");
  }

  private void lazyInit() {

  }
}