package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.core.rule.impl.AbstractRule;
import org.kie.workbench.common.stunner.core.rule.impl.CanDock;

public class Marshaller_o_k_w_c_s_c_r_i_CanDock_1_Impl implements GeneratedMarshaller<CanDock> {
  private CanDock[] EMPTY_ARRAY = new CanDock[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  public CanDock[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String AbstractRule_String_name(AbstractRule instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.rule.impl.AbstractRule::name;
  }-*/;

  native static void AbstractRule_String_name(AbstractRule instance, String value) /*-{
    instance.@org.kie.workbench.common.stunner.core.rule.impl.AbstractRule::name = value;
  }-*/;

  public CanDock demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(CanDock.class, objId);
    }
    final String c1 = java_lang_String.demarshall(obj.get("role"), a1);
    a1.setAssumedElementType("java.lang.String");
    final Set c2 = java_util_Set.demarshall(obj.get("allowedRoles"), a1);
    final String c0 = java_lang_String.demarshall(obj.get("name"), a1);
    CanDock entity = new CanDock(c0, c1, c2);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": AbstractRule_String_name(entity, java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(CanDock a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.rule.impl.CanDock") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "role") + "\":") + java_lang_String.marshall(a0.getRole(), a1)) + ",\"") + "allowedRoles") + "\":") + java_util_Set.marshall(a0.getAllowedRoles(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + "}");
  }

  private void lazyInit() {

  }
}