package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.core.rule.context.EdgeCardinalityContext.Direction;
import org.kie.workbench.common.stunner.core.rule.impl.AbstractOccurrences;
import org.kie.workbench.common.stunner.core.rule.impl.AbstractRule;
import org.kie.workbench.common.stunner.core.rule.impl.EdgeOccurrences;

public class Marshaller_o_k_w_c_s_c_r_i_EdgeOccurrences_1_Impl implements GeneratedMarshaller<EdgeOccurrences> {
  private EdgeOccurrences[] EMPTY_ARRAY = new EdgeOccurrences[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Direction> org_kie_workbench_common_stunner_core_rule_context_EdgeCardinalityContext_erraiD_Direction = null;
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  public EdgeOccurrences[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String AbstractOccurrences_String_role(AbstractOccurrences instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.rule.impl.AbstractOccurrences::role;
  }-*/;

  native static void AbstractOccurrences_String_role(AbstractOccurrences instance, String value) /*-{
    instance.@org.kie.workbench.common.stunner.core.rule.impl.AbstractOccurrences::role = value;
  }-*/;

  native static int AbstractOccurrences_int_minOccurrences(AbstractOccurrences instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.rule.impl.AbstractOccurrences::minOccurrences;
  }-*/;

  native static void AbstractOccurrences_int_minOccurrences(AbstractOccurrences instance, int value) /*-{
    instance.@org.kie.workbench.common.stunner.core.rule.impl.AbstractOccurrences::minOccurrences = value;
  }-*/;

  native static int AbstractOccurrences_int_maxOccurrences(AbstractOccurrences instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.rule.impl.AbstractOccurrences::maxOccurrences;
  }-*/;

  native static void AbstractOccurrences_int_maxOccurrences(AbstractOccurrences instance, int value) /*-{
    instance.@org.kie.workbench.common.stunner.core.rule.impl.AbstractOccurrences::maxOccurrences = value;
  }-*/;

  native static String AbstractRule_String_name(AbstractRule instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.rule.impl.AbstractRule::name;
  }-*/;

  native static void AbstractRule_String_name(AbstractRule instance, String value) /*-{
    instance.@org.kie.workbench.common.stunner.core.rule.impl.AbstractRule::name = value;
  }-*/;

  public EdgeOccurrences demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(EdgeOccurrences.class, objId);
    }
    final String c1 = java_lang_String.demarshall(obj.get("connectorRole"), a1);
    final Direction c3 = obj.get("direction").isObject() != null ? Enum.valueOf(Direction.class, obj.get("direction").isObject().get("^EnumStringValue").isString().stringValue()) : obj.get("direction").isString() != null ? Enum.valueOf(Direction.class, obj.get("direction").isString().stringValue()) : null;
    final String c2 = java_lang_String.demarshall(obj.get("role"), a1);
    final Integer c4 = java_lang_Integer.demarshall(obj.get("minOccurrences"), a1);
    final Integer c5 = java_lang_Integer.demarshall(obj.get("maxOccurrences"), a1);
    final String c0 = java_lang_String.demarshall(obj.get("name"), a1);
    EdgeOccurrences entity = new EdgeOccurrences(c0, c1, c2, c3, c4, c5);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "role": AbstractOccurrences_String_role(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "minOccurrences": AbstractOccurrences_int_minOccurrences(entity, java_lang_Integer.demarshall(objVal, a1));
        break;
        case "maxOccurrences": AbstractOccurrences_int_maxOccurrences(entity, java_lang_Integer.demarshall(objVal, a1));
        break;
        case "name": AbstractRule_String_name(entity, java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(EdgeOccurrences a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.rule.impl.EdgeOccurrences") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "connectorRole") + "\":") + java_lang_String.marshall(a0.getConnectorRole(), a1)) + ",\"") + "direction") + "\":") + (a0.getDirection() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.rule.context.EdgeCardinalityContext$Direction") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getDirection().name()) + "\"}" : "null")) + ",\"") + "role") + "\":") + java_lang_String.marshall(a0.getRole(), a1)) + ",\"") + "minOccurrences") + "\":") + java_lang_Integer.marshall(a0.getMinOccurrences(), a1)) + ",\"") + "maxOccurrences") + "\":") + java_lang_Integer.marshall(a0.getMaxOccurrences(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_stunner_core_rule_context_EdgeCardinalityContext_erraiD_Direction == null) {
      org_kie_workbench_common_stunner_core_rule_context_EdgeCardinalityContext_erraiD_Direction = Marshalling.getMarshaller(Direction.class);
    }
  }
}