package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;

public class Marshaller_o_k_w_c_s_c_r_v_DefaultRuleViolations_1_Impl implements GeneratedMarshaller<DefaultRuleViolations> {
  private DefaultRuleViolations[] EMPTY_ARRAY = new DefaultRuleViolations[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public DefaultRuleViolations[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static List DefaultRuleViolations_List_violations(DefaultRuleViolations instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations::violations;
  }-*/;

  native static void DefaultRuleViolations_List_violations(DefaultRuleViolations instance, List<RuleViolation> value) /*-{
    instance.@org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations::violations = value;
  }-*/;

  public DefaultRuleViolations demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DefaultRuleViolations.class, objId);
    }
    DefaultRuleViolations entity = new DefaultRuleViolations();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "violations": a1.setAssumedElementType("org.kie.workbench.common.stunner.core.rule.RuleViolation");
        DefaultRuleViolations_List_violations(entity, java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DefaultRuleViolations a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "violations") + "\":") + java_util_List.marshall(DefaultRuleViolations_List_violations(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}