package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.services.datamodeller.core.AnnotationRetention;
import org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition;
import org.kie.workbench.common.services.datamodeller.core.ElementType;
import org.kie.workbench.common.services.datamodeller.core.impl.AbstractAnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationDefinitionImpl;

public class Marshaller_o_k_w_c_s_d_c_i_AnnotationDefinitionImpl_1_Impl implements GeneratedMarshaller<AnnotationDefinitionImpl> {
  private AnnotationDefinitionImpl[] EMPTY_ARRAY = new AnnotationDefinitionImpl[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<AnnotationRetention> org_kie_workbench_common_services_datamodeller_core_AnnotationRetention = null;
  public AnnotationDefinitionImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String AbstractAnnotationDefinition_String_className(AbstractAnnotationDefinition instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractAnnotationDefinition::className;
  }-*/;

  native static void AbstractAnnotationDefinition_String_className(AbstractAnnotationDefinition instance, String value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractAnnotationDefinition::className = value;
  }-*/;

  native static List AbstractAnnotationDefinition_List_valuePairs(AbstractAnnotationDefinition instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractAnnotationDefinition::valuePairs;
  }-*/;

  native static void AbstractAnnotationDefinition_List_valuePairs(AbstractAnnotationDefinition instance, List<AnnotationValuePairDefinition> value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractAnnotationDefinition::valuePairs = value;
  }-*/;

  native static boolean AbstractAnnotationDefinition_boolean_objectAnnotation(AbstractAnnotationDefinition instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractAnnotationDefinition::objectAnnotation;
  }-*/;

  native static void AbstractAnnotationDefinition_boolean_objectAnnotation(AbstractAnnotationDefinition instance, boolean value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractAnnotationDefinition::objectAnnotation = value;
  }-*/;

  native static boolean AbstractAnnotationDefinition_boolean_propertyAnnotation(AbstractAnnotationDefinition instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractAnnotationDefinition::propertyAnnotation;
  }-*/;

  native static void AbstractAnnotationDefinition_boolean_propertyAnnotation(AbstractAnnotationDefinition instance, boolean value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractAnnotationDefinition::propertyAnnotation = value;
  }-*/;

  native static List AbstractAnnotationDefinition_List_targets(AbstractAnnotationDefinition instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractAnnotationDefinition::targets;
  }-*/;

  native static void AbstractAnnotationDefinition_List_targets(AbstractAnnotationDefinition instance, List<ElementType> value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractAnnotationDefinition::targets = value;
  }-*/;

  public AnnotationDefinitionImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(AnnotationDefinitionImpl.class, objId);
    }
    AnnotationDefinitionImpl entity = new AnnotationDefinitionImpl();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "className": AbstractAnnotationDefinition_String_className(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "valuePairs": a1.setAssumedElementType("org.kie.workbench.common.services.datamodeller.core.AnnotationValuePairDefinition");
        AbstractAnnotationDefinition_List_valuePairs(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "objectAnnotation": AbstractAnnotationDefinition_boolean_objectAnnotation(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "propertyAnnotation": AbstractAnnotationDefinition_boolean_propertyAnnotation(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "targets": a1.setAssumedElementType("org.kie.workbench.common.services.datamodeller.core.ElementType");
        AbstractAnnotationDefinition_List_targets(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "retention": entity.setRetention(objVal.isObject() != null ? Enum.valueOf(AnnotationRetention.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(AnnotationRetention.class, objVal.isString().stringValue()) : null);
        break;
      }
    }
    return entity;
  }

  public String marshall(AnnotationDefinitionImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.datamodeller.core.impl.AnnotationDefinitionImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "className") + "\":") + java_lang_String.marshall(a0.getClassName(), a1)) + ",\"") + "valuePairs") + "\":") + java_util_List.marshall(a0.getValuePairs(), a1)) + ",\"") + "objectAnnotation") + "\":") + java_lang_Boolean.marshall(AbstractAnnotationDefinition_boolean_objectAnnotation(a0), a1)) + ",\"") + "propertyAnnotation") + "\":") + java_lang_Boolean.marshall(AbstractAnnotationDefinition_boolean_propertyAnnotation(a0), a1)) + ",\"") + "targets") + "\":") + java_util_List.marshall(AbstractAnnotationDefinition_List_targets(a0), a1)) + ",\"") + "retention") + "\":") + (a0.getRetention() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.datamodeller.core.AnnotationRetention") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getRetention().name()) + "\"}" : "null")) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_services_datamodeller_core_AnnotationRetention == null) {
      org_kie_workbench_common_services_datamodeller_core_AnnotationRetention = Marshalling.getMarshaller(AnnotationRetention.class);
    }
  }
}