package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.impl.AbstractAnnotation;
import org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl;

public class Marshaller_o_k_w_c_s_d_c_i_AnnotationImpl_1_Impl implements GeneratedMarshaller<AnnotationImpl> {
  private AnnotationImpl[] EMPTY_ARRAY = new AnnotationImpl[0];
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  public AnnotationImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static AnnotationDefinition AbstractAnnotation_AnnotationDefinition_annotationDefinition(AbstractAnnotation instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractAnnotation::annotationDefinition;
  }-*/;

  native static void AbstractAnnotation_AnnotationDefinition_annotationDefinition(AbstractAnnotation instance, AnnotationDefinition value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractAnnotation::annotationDefinition = value;
  }-*/;

  native static Map AbstractAnnotation_Map_values(AbstractAnnotation instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractAnnotation::values;
  }-*/;

  native static void AbstractAnnotation_Map_values(AbstractAnnotation instance, Map value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractAnnotation::values = value;
  }-*/;

  public AnnotationImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(AnnotationImpl.class, objId);
    }
    AnnotationImpl entity = new AnnotationImpl();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "annotationDefinition": AbstractAnnotation_AnnotationDefinition_annotationDefinition(entity, (AnnotationDefinition) ((ObjectMarshaller) java_lang_Object).demarshall(AnnotationDefinition.class, objVal, a1));
        break;
        case "values": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("java.lang.Object");
        AbstractAnnotation_Map_values(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
      }
    }
    return entity;
  }

  public String marshall(AnnotationImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.datamodeller.core.impl.AnnotationImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "annotationDefinition") + "\":") + java_lang_Object.marshall(a0.getAnnotationDefinition(), a1)) + ",\"") + "values") + "\":") + java_util_Map.marshall(a0.getValues(), a1)) + "}");
  }

  private void lazyInit() {

  }
}