package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.JavaEnum;
import org.kie.workbench.common.services.datamodeller.core.impl.DataModelImpl;

public class Marshaller_o_k_w_c_s_d_c_i_DataModelImpl_1_Impl implements GeneratedMarshaller<DataModelImpl> {
  private DataModelImpl[] EMPTY_ARRAY = new DataModelImpl[0];
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  public DataModelImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Map DataModelImpl_Map_dataObjects(DataModelImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.DataModelImpl::dataObjects;
  }-*/;

  native static void DataModelImpl_Map_dataObjects(DataModelImpl instance, Map<String, DataObject> value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.DataModelImpl::dataObjects = value;
  }-*/;

  native static Map DataModelImpl_Map_dependencyDataObjects(DataModelImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.DataModelImpl::dependencyDataObjects;
  }-*/;

  native static void DataModelImpl_Map_dependencyDataObjects(DataModelImpl instance, Map<String, DataObject> value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.DataModelImpl::dependencyDataObjects = value;
  }-*/;

  native static Map DataModelImpl_Map_javaEnums(DataModelImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.DataModelImpl::javaEnums;
  }-*/;

  native static void DataModelImpl_Map_javaEnums(DataModelImpl instance, Map<String, JavaEnum> value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.DataModelImpl::javaEnums = value;
  }-*/;

  native static Map DataModelImpl_Map_dependencyJavaEnums(DataModelImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.DataModelImpl::dependencyJavaEnums;
  }-*/;

  native static void DataModelImpl_Map_dependencyJavaEnums(DataModelImpl instance, Map<String, JavaEnum> value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.DataModelImpl::dependencyJavaEnums = value;
  }-*/;

  public DataModelImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DataModelImpl.class, objId);
    }
    DataModelImpl entity = new DataModelImpl();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "dataObjects": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("org.kie.workbench.common.services.datamodeller.core.DataObject");
        DataModelImpl_Map_dataObjects(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "dependencyDataObjects": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("org.kie.workbench.common.services.datamodeller.core.DataObject");
        DataModelImpl_Map_dependencyDataObjects(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "javaEnums": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("org.kie.workbench.common.services.datamodeller.core.JavaEnum");
        DataModelImpl_Map_javaEnums(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "dependencyJavaEnums": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("org.kie.workbench.common.services.datamodeller.core.JavaEnum");
        DataModelImpl_Map_dependencyJavaEnums(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
      }
    }
    return entity;
  }

  public String marshall(DataModelImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.datamodeller.core.impl.DataModelImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((("" + ",\"") + "dataObjects") + "\":") + java_util_Map.marshall(DataModelImpl_Map_dataObjects(a0), a1)) + ",\"") + "dependencyDataObjects") + "\":") + java_util_Map.marshall(DataModelImpl_Map_dependencyDataObjects(a0), a1)) + ",\"") + "javaEnums") + "\":") + java_util_Map.marshall(DataModelImpl_Map_javaEnums(a0), a1)) + ",\"") + "dependencyJavaEnums") + "\":") + java_util_Map.marshall(DataModelImpl_Map_dependencyJavaEnums(a0), a1)) + "}");
  }

  private void lazyInit() {

  }
}