package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.services.datamodeller.core.impl.ImportImpl;

public class Marshaller_o_k_w_c_s_d_c_i_ImportImpl_1_Impl implements GeneratedMarshaller<ImportImpl> {
  private ImportImpl[] EMPTY_ARRAY = new ImportImpl[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public ImportImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String ImportImpl_String_name(ImportImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.ImportImpl::name;
  }-*/;

  native static void ImportImpl_String_name(ImportImpl instance, String value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.ImportImpl::name = value;
  }-*/;

  public ImportImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ImportImpl.class, objId);
    }
    ImportImpl entity = new ImportImpl();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": ImportImpl_String_name(entity, java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ImportImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.datamodeller.core.impl.ImportImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + "}");
  }

  private void lazyInit() {

  }
}