package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.Import;
import org.kie.workbench.common.services.datamodeller.core.JavaClass;
import org.kie.workbench.common.services.datamodeller.core.JavaType;
import org.kie.workbench.common.services.datamodeller.core.JavaTypeKind;
import org.kie.workbench.common.services.datamodeller.core.Method;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.core.impl.AbstractHasAnnotations;
import org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType;
import org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl;

public class Marshaller_o_k_w_c_s_d_c_i_JavaClassImpl_1_Impl implements GeneratedMarshaller<JavaClassImpl> {
  private JavaClassImpl[] EMPTY_ARRAY = new JavaClassImpl[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<Visibility> org_kie_workbench_common_services_datamodeller_core_Visibility = null;
  private Marshaller<JavaTypeKind> org_kie_workbench_common_services_datamodeller_core_JavaTypeKind = null;
  public JavaClassImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static List JavaClassImpl_List_interfaces(JavaClassImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl::interfaces;
  }-*/;

  native static void JavaClassImpl_List_interfaces(JavaClassImpl instance, List<String> value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl::interfaces = value;
  }-*/;

  native static List JavaClassImpl_List_nestedClasses(JavaClassImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl::nestedClasses;
  }-*/;

  native static void JavaClassImpl_List_nestedClasses(JavaClassImpl instance, List<JavaClass> value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl::nestedClasses = value;
  }-*/;

  native static List JavaClassImpl_List_methods(JavaClassImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl::methods;
  }-*/;

  native static void JavaClassImpl_List_methods(JavaClassImpl instance, List<Method> value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl::methods = value;
  }-*/;

  native static List JavaClassImpl_List_imports(JavaClassImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl::imports;
  }-*/;

  native static void JavaClassImpl_List_imports(JavaClassImpl instance, List<Import> value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl::imports = value;
  }-*/;

  native static boolean JavaClassImpl_boolean__static(JavaClassImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl::_static;
  }-*/;

  native static void JavaClassImpl_boolean__static(JavaClassImpl instance, boolean value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl::_static = value;
  }-*/;

  native static boolean JavaClassImpl_boolean__final(JavaClassImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl::_final;
  }-*/;

  native static void JavaClassImpl_boolean__final(JavaClassImpl instance, boolean value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl::_final = value;
  }-*/;

  native static boolean JavaClassImpl_boolean__abstract(JavaClassImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl::_abstract;
  }-*/;

  native static void JavaClassImpl_boolean__abstract(JavaClassImpl instance, boolean value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl::_abstract = value;
  }-*/;

  native static JavaType AbstractJavaType_JavaType_enclosingType(AbstractJavaType instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType::enclosingType;
  }-*/;

  native static void AbstractJavaType_JavaType_enclosingType(AbstractJavaType instance, JavaType value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType::enclosingType = value;
  }-*/;

  native static List AbstractJavaType_List_nestedTypes(AbstractJavaType instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType::nestedTypes;
  }-*/;

  native static void AbstractJavaType_List_nestedTypes(AbstractJavaType instance, List<JavaType> value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType::nestedTypes = value;
  }-*/;

  native static JavaTypeKind AbstractJavaType_JavaTypeKind_typeKind(AbstractJavaType instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType::typeKind;
  }-*/;

  native static void AbstractJavaType_JavaTypeKind_typeKind(AbstractJavaType instance, JavaTypeKind value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType::typeKind = value;
  }-*/;

  native static List AbstractHasAnnotations_List_annotations(AbstractHasAnnotations instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractHasAnnotations::annotations;
  }-*/;

  native static void AbstractHasAnnotations_List_annotations(AbstractHasAnnotations instance, List<Annotation> value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractHasAnnotations::annotations = value;
  }-*/;

  public JavaClassImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(JavaClassImpl.class, objId);
    }
    JavaClassImpl entity = new JavaClassImpl();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "superClassName": entity.setSuperClassName(java_lang_String.demarshall(objVal, a1));
        break;
        case "interfaces": a1.setAssumedElementType("java.lang.String");
        JavaClassImpl_List_interfaces(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "nestedClasses": a1.setAssumedElementType("org.kie.workbench.common.services.datamodeller.core.JavaClass");
        JavaClassImpl_List_nestedClasses(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "methods": a1.setAssumedElementType("org.kie.workbench.common.services.datamodeller.core.Method");
        JavaClassImpl_List_methods(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "imports": a1.setAssumedElementType("org.kie.workbench.common.services.datamodeller.core.Import");
        JavaClassImpl_List_imports(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "_static": JavaClassImpl_boolean__static(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "_final": JavaClassImpl_boolean__final(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "_abstract": JavaClassImpl_boolean__abstract(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "packageName": entity.setPackageName(java_lang_String.demarshall(objVal, a1));
        break;
        case "enclosingType": AbstractJavaType_JavaType_enclosingType(entity, (JavaType) ((ObjectMarshaller) java_lang_Object).demarshall(JavaType.class, objVal, a1));
        break;
        case "nestedTypes": a1.setAssumedElementType("org.kie.workbench.common.services.datamodeller.core.JavaType");
        AbstractJavaType_List_nestedTypes(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "visibility": entity.setVisibility(objVal.isObject() != null ? Enum.valueOf(Visibility.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(Visibility.class, objVal.isString().stringValue()) : null);
        break;
        case "typeKind": AbstractJavaType_JavaTypeKind_typeKind(entity, objVal.isObject() != null ? Enum.valueOf(JavaTypeKind.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(JavaTypeKind.class, objVal.isString().stringValue()) : null);
        break;
        case "annotations": a1.setAssumedElementType("org.kie.workbench.common.services.datamodeller.core.Annotation");
        AbstractHasAnnotations_List_annotations(entity, java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static Visibility AbstractJavaType_Visibility_visibility(AbstractJavaType instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType::visibility;
  }-*/;

  native static void AbstractJavaType_Visibility_visibility(AbstractJavaType instance, Visibility value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType::visibility = value;
  }-*/;

  public String marshall(JavaClassImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.datamodeller.core.impl.JavaClassImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "superClassName") + "\":") + java_lang_String.marshall(a0.getSuperClassName(), a1)) + ",\"") + "interfaces") + "\":") + java_util_List.marshall(a0.getInterfaces(), a1)) + ",\"") + "nestedClasses") + "\":") + java_util_List.marshall(a0.getNestedClasses(), a1)) + ",\"") + "methods") + "\":") + java_util_List.marshall(a0.getMethods(), a1)) + ",\"") + "imports") + "\":") + java_util_List.marshall(a0.getImports(), a1)) + ",\"") + "_static") + "\":") + java_lang_Boolean.marshall(JavaClassImpl_boolean__static(a0), a1)) + ",\"") + "_final") + "\":") + java_lang_Boolean.marshall(JavaClassImpl_boolean__final(a0), a1)) + ",\"") + "_abstract") + "\":") + java_lang_Boolean.marshall(JavaClassImpl_boolean__abstract(a0), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "packageName") + "\":") + java_lang_String.marshall(a0.getPackageName(), a1)) + ",\"") + "enclosingType") + "\":") + java_lang_Object.marshall(a0.getEnclosingType(), a1)) + ",\"") + "nestedTypes") + "\":") + java_util_List.marshall(a0.getNestedTypes(), a1)) + ",\"") + "visibility") + "\":") + (AbstractJavaType_Visibility_visibility(a0) != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.datamodeller.core.Visibility") + "\",\"") + "^EnumStringValue") + "\":\"") + AbstractJavaType_Visibility_visibility(a0).name()) + "\"}" : "null")) + ",\"") + "typeKind") + "\":") + (a0.getTypeKind() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.datamodeller.core.JavaTypeKind") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getTypeKind().name()) + "\"}" : "null")) + ",\"") + "annotations") + "\":") + java_util_List.marshall(a0.getAnnotations(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_services_datamodeller_core_Visibility == null) {
      org_kie_workbench_common_services_datamodeller_core_Visibility = Marshalling.getMarshaller(Visibility.class);
    }
    if (org_kie_workbench_common_services_datamodeller_core_JavaTypeKind == null) {
      org_kie_workbench_common_services_datamodeller_core_JavaTypeKind = Marshalling.getMarshaller(JavaTypeKind.class);
    }
  }
}