package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.JavaType;
import org.kie.workbench.common.services.datamodeller.core.JavaTypeKind;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.core.impl.AbstractHasAnnotations;
import org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType;
import org.kie.workbench.common.services.datamodeller.core.impl.JavaInterfaceImpl;

public class Marshaller_o_k_w_c_s_d_c_i_JavaInterfaceImpl_1_Impl implements GeneratedMarshaller<JavaInterfaceImpl> {
  private JavaInterfaceImpl[] EMPTY_ARRAY = new JavaInterfaceImpl[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<Visibility> org_kie_workbench_common_services_datamodeller_core_Visibility = null;
  private Marshaller<JavaTypeKind> org_kie_workbench_common_services_datamodeller_core_JavaTypeKind = null;
  public JavaInterfaceImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static List JavaInterfaceImpl_List_interfaces(JavaInterfaceImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.JavaInterfaceImpl::interfaces;
  }-*/;

  native static void JavaInterfaceImpl_List_interfaces(JavaInterfaceImpl instance, List<String> value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.JavaInterfaceImpl::interfaces = value;
  }-*/;

  native static JavaType AbstractJavaType_JavaType_enclosingType(AbstractJavaType instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType::enclosingType;
  }-*/;

  native static void AbstractJavaType_JavaType_enclosingType(AbstractJavaType instance, JavaType value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType::enclosingType = value;
  }-*/;

  native static List AbstractJavaType_List_nestedTypes(AbstractJavaType instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType::nestedTypes;
  }-*/;

  native static void AbstractJavaType_List_nestedTypes(AbstractJavaType instance, List<JavaType> value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType::nestedTypes = value;
  }-*/;

  native static JavaTypeKind AbstractJavaType_JavaTypeKind_typeKind(AbstractJavaType instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType::typeKind;
  }-*/;

  native static void AbstractJavaType_JavaTypeKind_typeKind(AbstractJavaType instance, JavaTypeKind value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType::typeKind = value;
  }-*/;

  native static List AbstractHasAnnotations_List_annotations(AbstractHasAnnotations instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractHasAnnotations::annotations;
  }-*/;

  native static void AbstractHasAnnotations_List_annotations(AbstractHasAnnotations instance, List<Annotation> value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractHasAnnotations::annotations = value;
  }-*/;

  public JavaInterfaceImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(JavaInterfaceImpl.class, objId);
    }
    JavaInterfaceImpl entity = new JavaInterfaceImpl();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "interfaces": a1.setAssumedElementType("java.lang.String");
        JavaInterfaceImpl_List_interfaces(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "packageName": entity.setPackageName(java_lang_String.demarshall(objVal, a1));
        break;
        case "enclosingType": AbstractJavaType_JavaType_enclosingType(entity, (JavaType) ((ObjectMarshaller) java_lang_Object).demarshall(JavaType.class, objVal, a1));
        break;
        case "nestedTypes": a1.setAssumedElementType("org.kie.workbench.common.services.datamodeller.core.JavaType");
        AbstractJavaType_List_nestedTypes(entity, java_util_List.demarshall(objVal, a1));
        break;
        case "visibility": entity.setVisibility(objVal.isObject() != null ? Enum.valueOf(Visibility.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(Visibility.class, objVal.isString().stringValue()) : null);
        break;
        case "typeKind": AbstractJavaType_JavaTypeKind_typeKind(entity, objVal.isObject() != null ? Enum.valueOf(JavaTypeKind.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(JavaTypeKind.class, objVal.isString().stringValue()) : null);
        break;
        case "annotations": a1.setAssumedElementType("org.kie.workbench.common.services.datamodeller.core.Annotation");
        AbstractHasAnnotations_List_annotations(entity, java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static Visibility AbstractJavaType_Visibility_visibility(AbstractJavaType instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType::visibility;
  }-*/;

  native static void AbstractJavaType_Visibility_visibility(AbstractJavaType instance, Visibility value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractJavaType::visibility = value;
  }-*/;

  public String marshall(JavaInterfaceImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.datamodeller.core.impl.JavaInterfaceImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((("" + ",\"") + "interfaces") + "\":") + java_util_List.marshall(a0.getInterfaces(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "packageName") + "\":") + java_lang_String.marshall(a0.getPackageName(), a1)) + ",\"") + "enclosingType") + "\":") + java_lang_Object.marshall(a0.getEnclosingType(), a1)) + ",\"") + "nestedTypes") + "\":") + java_util_List.marshall(a0.getNestedTypes(), a1)) + ",\"") + "visibility") + "\":") + (AbstractJavaType_Visibility_visibility(a0) != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.datamodeller.core.Visibility") + "\",\"") + "^EnumStringValue") + "\":\"") + AbstractJavaType_Visibility_visibility(a0).name()) + "\"}" : "null")) + ",\"") + "typeKind") + "\":") + (a0.getTypeKind() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.datamodeller.core.JavaTypeKind") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getTypeKind().name()) + "\"}" : "null")) + ",\"") + "annotations") + "\":") + java_util_List.marshall(a0.getAnnotations(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_services_datamodeller_core_Visibility == null) {
      org_kie_workbench_common_services_datamodeller_core_Visibility = Marshalling.getMarshaller(Visibility.class);
    }
    if (org_kie_workbench_common_services_datamodeller_core_JavaTypeKind == null) {
      org_kie_workbench_common_services_datamodeller_core_JavaTypeKind = Marshalling.getMarshaller(JavaTypeKind.class);
    }
  }
}