package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.Type;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.core.impl.AbstractHasAnnotations;
import org.kie.workbench.common.services.datamodeller.core.impl.MethodImpl;

public class Marshaller_o_k_w_c_s_d_c_i_MethodImpl_1_Impl implements GeneratedMarshaller<MethodImpl> {
  private MethodImpl[] EMPTY_ARRAY = new MethodImpl[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<Visibility> org_kie_workbench_common_services_datamodeller_core_Visibility = null;
  public MethodImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static List AbstractHasAnnotations_List_annotations(AbstractHasAnnotations instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractHasAnnotations::annotations;
  }-*/;

  native static void AbstractHasAnnotations_List_annotations(AbstractHasAnnotations instance, List<Annotation> value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractHasAnnotations::annotations = value;
  }-*/;

  public MethodImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(MethodImpl.class, objId);
    }
    MethodImpl entity = new MethodImpl();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "parameters": a1.setAssumedElementType("org.kie.workbench.common.services.datamodeller.core.Parameter");
        entity.setParameters(java_util_List.demarshall(objVal, a1));
        break;
        case "body": entity.setBody(java_lang_String.demarshall(objVal, a1));
        break;
        case "returnType": entity.setReturnType((Type) ((ObjectMarshaller) java_lang_Object).demarshall(Type.class, objVal, a1));
        break;
        case "visibility": entity.setVisibility(objVal.isObject() != null ? Enum.valueOf(Visibility.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(Visibility.class, objVal.isString().stringValue()) : null);
        break;
        case "annotations": a1.setAssumedElementType("org.kie.workbench.common.services.datamodeller.core.Annotation");
        AbstractHasAnnotations_List_annotations(entity, java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static Visibility MethodImpl_Visibility_visibility(MethodImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.MethodImpl::visibility;
  }-*/;

  native static void MethodImpl_Visibility_visibility(MethodImpl instance, Visibility value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.MethodImpl::visibility = value;
  }-*/;

  public String marshall(MethodImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.datamodeller.core.impl.MethodImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "parameters") + "\":") + java_util_List.marshall(a0.getParameters(), a1)) + ",\"") + "body") + "\":") + java_lang_String.marshall(a0.getBody(), a1)) + ",\"") + "returnType") + "\":") + java_lang_Object.marshall(a0.getReturnType(), a1)) + ",\"") + "visibility") + "\":") + (MethodImpl_Visibility_visibility(a0) != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.datamodeller.core.Visibility") + "\",\"") + "^EnumStringValue") + "\":\"") + MethodImpl_Visibility_visibility(a0).name()) + "\"}" : "null")) + ",\"") + "annotations") + "\":") + java_util_List.marshall(a0.getAnnotations(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_services_datamodeller_core_Visibility == null) {
      org_kie_workbench_common_services_datamodeller_core_Visibility = Marshalling.getMarshaller(Visibility.class);
    }
  }
}