package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.Visibility;
import org.kie.workbench.common.services.datamodeller.core.impl.AbstractHasAnnotations;
import org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl;

public class Marshaller_o_k_w_c_s_d_c_i_ObjectPropertyImpl_1_Impl implements GeneratedMarshaller<ObjectPropertyImpl> {
  private ObjectPropertyImpl[] EMPTY_ARRAY = new ObjectPropertyImpl[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  private Marshaller<Visibility> org_kie_workbench_common_services_datamodeller_core_Visibility = null;
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public ObjectPropertyImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static int ObjectPropertyImpl_int_modifiers(ObjectPropertyImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl::modifiers;
  }-*/;

  native static void ObjectPropertyImpl_int_modifiers(ObjectPropertyImpl instance, int value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl::modifiers = value;
  }-*/;

  native static boolean ObjectPropertyImpl_boolean__static(ObjectPropertyImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl::_static;
  }-*/;

  native static void ObjectPropertyImpl_boolean__static(ObjectPropertyImpl instance, boolean value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl::_static = value;
  }-*/;

  native static boolean ObjectPropertyImpl_boolean__final(ObjectPropertyImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl::_final;
  }-*/;

  native static void ObjectPropertyImpl_boolean__final(ObjectPropertyImpl instance, boolean value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl::_final = value;
  }-*/;

  native static List AbstractHasAnnotations_List_annotations(AbstractHasAnnotations instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractHasAnnotations::annotations;
  }-*/;

  native static void AbstractHasAnnotations_List_annotations(AbstractHasAnnotations instance, List<Annotation> value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.AbstractHasAnnotations::annotations = value;
  }-*/;

  public ObjectPropertyImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ObjectPropertyImpl.class, objId);
    }
    ObjectPropertyImpl entity = new ObjectPropertyImpl();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "className": entity.setClassName(java_lang_String.demarshall(objVal, a1));
        break;
        case "bag": entity.setBag(java_lang_String.demarshall(objVal, a1));
        break;
        case "multiple": entity.setMultiple(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "modifiers": ObjectPropertyImpl_int_modifiers(entity, java_lang_Integer.demarshall(objVal, a1));
        break;
        case "fileOrder": entity.setFileOrder(java_lang_Integer.demarshall(objVal, a1));
        break;
        case "visibility": entity.setVisibility(objVal.isObject() != null ? Enum.valueOf(Visibility.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(Visibility.class, objVal.isString().stringValue()) : null);
        break;
        case "_static": ObjectPropertyImpl_boolean__static(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "_final": ObjectPropertyImpl_boolean__final(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "annotations": a1.setAssumedElementType("org.kie.workbench.common.services.datamodeller.core.Annotation");
        AbstractHasAnnotations_List_annotations(entity, java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static boolean ObjectPropertyImpl_boolean_multiple(ObjectPropertyImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl::multiple;
  }-*/;

  native static void ObjectPropertyImpl_boolean_multiple(ObjectPropertyImpl instance, boolean value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl::multiple = value;
  }-*/;

  native static Visibility ObjectPropertyImpl_Visibility_visibility(ObjectPropertyImpl instance) /*-{
    return instance.@org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl::visibility;
  }-*/;

  native static void ObjectPropertyImpl_Visibility_visibility(ObjectPropertyImpl instance, Visibility value) /*-{
    instance.@org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl::visibility = value;
  }-*/;

  public String marshall(ObjectPropertyImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.datamodeller.core.impl.ObjectPropertyImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "className") + "\":") + java_lang_String.marshall(a0.getClassName(), a1)) + ",\"") + "bag") + "\":") + java_lang_String.marshall(a0.getBag(), a1)) + ",\"") + "multiple") + "\":") + java_lang_Boolean.marshall(ObjectPropertyImpl_boolean_multiple(a0), a1)) + ",\"") + "modifiers") + "\":") + java_lang_Integer.marshall(a0.getModifiers(), a1)) + ",\"") + "fileOrder") + "\":") + java_lang_Integer.marshall(a0.getFileOrder(), a1)) + ",\"") + "visibility") + "\":") + (ObjectPropertyImpl_Visibility_visibility(a0) != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.services.datamodeller.core.Visibility") + "\",\"") + "^EnumStringValue") + "\":\"") + ObjectPropertyImpl_Visibility_visibility(a0).name()) + "\"}" : "null")) + ",\"") + "_static") + "\":") + java_lang_Boolean.marshall(ObjectPropertyImpl_boolean__static(a0), a1)) + ",\"") + "_final") + "\":") + java_lang_Boolean.marshall(ObjectPropertyImpl_boolean__final(a0), a1)) + ",\"") + "annotations") + "\":") + java_util_List.marshall(a0.getAnnotations(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_services_datamodeller_core_Visibility == null) {
      org_kie_workbench_common_services_datamodeller_core_Visibility = Marshalling.getMarshaller(Visibility.class);
    }
  }
}