package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.common.services.project.model.Module;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.screens.datamodeller.events.DataModelReload;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.Method;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.uberfire.backend.vfs.Path;

public class Marshaller_o_k_w_c_s_d_e_DataModelReload_1_Impl implements GeneratedMarshaller<DataModelReload> {
  private DataModelReload[] EMPTY_ARRAY = new DataModelReload[0];
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public DataModelReload[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public DataModelReload demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DataModelReload.class, objId);
    }
    DataModelReload entity = new DataModelReload();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "currentDataObject": entity.setCurrentDataObject((DataObject) ((ObjectMarshaller) java_lang_Object).demarshall(DataObject.class, objVal, a1));
        break;
        case "currentField": entity.setCurrentField((ObjectProperty) ((ObjectMarshaller) java_lang_Object).demarshall(ObjectProperty.class, objVal, a1));
        break;
        case "currentMethod": entity.setCurrentMethod((Method) ((ObjectMarshaller) java_lang_Object).demarshall(Method.class, objVal, a1));
        break;
        case "currentModule": entity.setCurrentModule((Module) ((ObjectMarshaller) java_lang_Object).demarshall(Module.class, objVal, a1));
        break;
        case "source": entity.setSource(java_lang_String.demarshall(objVal, a1));
        break;
        case "contextId": entity.setContextId(java_lang_String.demarshall(objVal, a1));
        break;
        case "path": entity.setPath((Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DataModelReload a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datamodeller.events.DataModelReload") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((("" + ",\"") + "currentDataObject") + "\":") + java_lang_Object.marshall(a0.getCurrentDataObject(), a1)) + ",\"") + "currentField") + "\":") + java_lang_Object.marshall(a0.getCurrentField(), a1)) + ",\"") + "currentMethod") + "\":") + java_lang_Object.marshall(a0.getCurrentMethod(), a1)) + ",\"") + "currentModule") + "\":") + java_lang_Object.marshall(a0.getCurrentModule(), a1)) + ",\"") + "source") + "\":") + java_lang_String.marshall(a0.getSource(), a1)) + ",\"") + "contextId") + "\":") + java_lang_String.marshall(a0.getContextId(), a1)) + ",\"") + "path") + "\":") + java_lang_Object.marshall(a0.getPath(), a1)) + "}");
  }

  private void lazyInit() {

  }
}