package org.jboss.errai.marshalling.client.api;

import java.util.Map;
import java.util.Set;
import org.guvnor.common.services.project.model.Module;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.screens.datamodeller.events.ChangeType;
import org.kie.workbench.common.screens.datamodeller.events.DataModelerValueChangeEvent;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.Method;
import org.kie.workbench.common.services.datamodeller.core.ObjectProperty;
import org.uberfire.backend.vfs.Path;

public class Marshaller_o_k_w_c_s_d_e_DataModelerValueChangeEvent_1_Impl implements GeneratedMarshaller<DataModelerValueChangeEvent> {
  private DataModelerValueChangeEvent[] EMPTY_ARRAY = new DataModelerValueChangeEvent[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<ChangeType> org_kie_workbench_common_screens_datamodeller_events_ChangeType = null;
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  public DataModelerValueChangeEvent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Map DataModelerValueChangeEvent_Map_changeParams(DataModelerValueChangeEvent instance) /*-{
    return instance.@org.kie.workbench.common.screens.datamodeller.events.DataModelerValueChangeEvent::changeParams;
  }-*/;

  native static void DataModelerValueChangeEvent_Map_changeParams(DataModelerValueChangeEvent instance, Map value) /*-{
    instance.@org.kie.workbench.common.screens.datamodeller.events.DataModelerValueChangeEvent::changeParams = value;
  }-*/;

  public DataModelerValueChangeEvent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DataModelerValueChangeEvent.class, objId);
    }
    DataModelerValueChangeEvent entity = new DataModelerValueChangeEvent();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "valueName": entity.setValueName(java_lang_String.demarshall(objVal, a1));
        break;
        case "oldValue": entity.setOldValue(((ObjectMarshaller) java_lang_Object).demarshall(Object.class, objVal, a1));
        break;
        case "newValue": entity.setNewValue(((ObjectMarshaller) java_lang_Object).demarshall(Object.class, objVal, a1));
        break;
        case "changeType": entity.setChangeType(objVal.isObject() != null ? Enum.valueOf(ChangeType.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(ChangeType.class, objVal.isString().stringValue()) : null);
        break;
        case "changeParams": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("java.lang.Object");
        DataModelerValueChangeEvent_Map_changeParams(entity, java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "currentDataObject": entity.setCurrentDataObject((DataObject) ((ObjectMarshaller) java_lang_Object).demarshall(DataObject.class, objVal, a1));
        break;
        case "currentField": entity.setCurrentField((ObjectProperty) ((ObjectMarshaller) java_lang_Object).demarshall(ObjectProperty.class, objVal, a1));
        break;
        case "currentMethod": entity.setCurrentMethod((Method) ((ObjectMarshaller) java_lang_Object).demarshall(Method.class, objVal, a1));
        break;
        case "currentModule": entity.setCurrentModule((Module) ((ObjectMarshaller) java_lang_Object).demarshall(Module.class, objVal, a1));
        break;
        case "source": entity.setSource(java_lang_String.demarshall(objVal, a1));
        break;
        case "contextId": entity.setContextId(java_lang_String.demarshall(objVal, a1));
        break;
        case "path": entity.setPath((Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DataModelerValueChangeEvent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datamodeller.events.DataModelerValueChangeEvent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "valueName") + "\":") + java_lang_String.marshall(a0.getValueName(), a1)) + ",\"") + "oldValue") + "\":") + java_lang_Object.marshall(a0.getOldValue(), a1)) + ",\"") + "newValue") + "\":") + java_lang_Object.marshall(a0.getNewValue(), a1)) + ",\"") + "changeType") + "\":") + (a0.getChangeType() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datamodeller.events.ChangeType") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getChangeType().name()) + "\"}" : "null")) + ",\"") + "changeParams") + "\":") + java_util_Map.marshall(DataModelerValueChangeEvent_Map_changeParams(a0), a1)) + ",\"") + "currentDataObject") + "\":") + java_lang_Object.marshall(a0.getCurrentDataObject(), a1)) + ",\"") + "currentField") + "\":") + java_lang_Object.marshall(a0.getCurrentField(), a1)) + ",\"") + "currentMethod") + "\":") + java_lang_Object.marshall(a0.getCurrentMethod(), a1)) + ",\"") + "currentModule") + "\":") + java_lang_Object.marshall(a0.getCurrentModule(), a1)) + ",\"") + "source") + "\":") + java_lang_String.marshall(a0.getSource(), a1)) + ",\"") + "contextId") + "\":") + java_lang_String.marshall(a0.getContextId(), a1)) + ",\"") + "path") + "\":") + java_lang_Object.marshall(a0.getPath(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_screens_datamodeller_events_ChangeType == null) {
      org_kie_workbench_common_screens_datamodeller_events_ChangeType = Marshalling.getMarshaller(ChangeType.class);
    }
  }
}