package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.common.services.shared.message.Level;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.screens.datamodeller.model.DataModelerError;
import org.uberfire.backend.vfs.Path;

public class Marshaller_o_k_w_c_s_d_m_DataModelerError_1_Impl implements GeneratedMarshaller<DataModelerError> {
  private DataModelerError[] EMPTY_ARRAY = new DataModelerError[0];
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  private Marshaller<Level> org_guvnor_common_services_shared_message_Level = null;
  public DataModelerError[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public DataModelerError demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DataModelerError.class, objId);
    }
    DataModelerError entity = new DataModelerError();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "id": entity.setId(java_lang_Long.demarshall(objVal, a1));
        break;
        case "message": entity.setMessage(java_lang_String.demarshall(objVal, a1));
        break;
        case "file": entity.setFile((Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "line": entity.setLine(java_lang_Integer.demarshall(objVal, a1));
        break;
        case "column": entity.setColumn(java_lang_Integer.demarshall(objVal, a1));
        break;
        case "level": entity.setLevel(objVal.isObject() != null ? Enum.valueOf(Level.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(Level.class, objVal.isString().stringValue()) : null);
        break;
      }
    }
    return entity;
  }

  public String marshall(DataModelerError a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datamodeller.model.DataModelerError") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "id") + "\":") + java_lang_Long.marshall(a0.getId(), a1)) + ",\"") + "message") + "\":") + java_lang_String.marshall(a0.getMessage(), a1)) + ",\"") + "file") + "\":") + java_lang_Object.marshall(a0.getFile(), a1)) + ",\"") + "line") + "\":") + java_lang_Integer.marshall(a0.getLine(), a1)) + ",\"") + "column") + "\":") + java_lang_Integer.marshall(a0.getColumn(), a1)) + ",\"") + "level") + "\":") + (a0.getLevel() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.guvnor.common.services.shared.message.Level") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getLevel().name()) + "\"}" : "null")) + "}");
  }

  private void lazyInit() {
    if (org_guvnor_common_services_shared_message_Level == null) {
      org_guvnor_common_services_shared_message_Level = Marshalling.getMarshaller(Level.class);
    }
  }
}