package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.screens.datamodeller.model.EditorModelContent;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.uberfire.backend.vfs.Path;

public class Marshaller_o_k_w_c_s_d_m_EditorModelContent_1_Impl implements GeneratedMarshaller<EditorModelContent> {
  private EditorModelContent[] EMPTY_ARRAY = new EditorModelContent[0];
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Overview> org_guvnor_common_services_shared_metadata_model_Overview = null;
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  private Marshaller<KieModule> org_kie_workbench_common_services_shared_project_KieModule = null;
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public EditorModelContent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public EditorModelContent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(EditorModelContent.class, objId);
    }
    EditorModelContent entity = new EditorModelContent();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "dataModel": entity.setDataModel((DataModel) ((ObjectMarshaller) java_lang_Object).demarshall(DataModel.class, objVal, a1));
        break;
        case "dataObject": entity.setDataObject((DataObject) ((ObjectMarshaller) java_lang_Object).demarshall(DataObject.class, objVal, a1));
        break;
        case "originalClassName": entity.setOriginalClassName(java_lang_String.demarshall(objVal, a1));
        break;
        case "originalPackageName": entity.setOriginalPackageName(java_lang_String.demarshall(objVal, a1));
        break;
        case "path": entity.setPath((Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "source": entity.setSource(java_lang_String.demarshall(objVal, a1));
        break;
        case "overview": entity.setOverview(org_guvnor_common_services_shared_metadata_model_Overview.demarshall(objVal, a1));
        break;
        case "elapsedTime": entity.setElapsedTime(java_lang_Long.demarshall(objVal, a1));
        break;
        case "currentModule": entity.setCurrentModule(org_kie_workbench_common_services_shared_project_KieModule.demarshall(objVal, a1));
        break;
        case "currentModulePackages": a1.setAssumedElementType("java.lang.String");
        entity.setCurrentModulePackages(java_util_Set.demarshall(objVal, a1));
        break;
        case "dataObjectPaths": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("org.uberfire.backend.vfs.Path");
        entity.setDataObjectPaths(java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "annotationDefinitions": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition");
        entity.setAnnotationDefinitions(java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "propertyTypes": a1.setAssumedElementType("org.kie.workbench.common.services.datamodeller.core.PropertyType");
        entity.setPropertyTypes(java_util_List.demarshall(objVal, a1));
        break;
        case "errors": a1.setAssumedElementType("org.kie.workbench.common.screens.datamodeller.model.DataModelerError");
        entity.setErrors(java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(EditorModelContent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datamodeller.model.EditorModelContent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "dataModel") + "\":") + java_lang_Object.marshall(a0.getDataModel(), a1)) + ",\"") + "dataObject") + "\":") + java_lang_Object.marshall(a0.getDataObject(), a1)) + ",\"") + "originalClassName") + "\":") + java_lang_String.marshall(a0.getOriginalClassName(), a1)) + ",\"") + "originalPackageName") + "\":") + java_lang_String.marshall(a0.getOriginalPackageName(), a1)) + ",\"") + "path") + "\":") + java_lang_Object.marshall(a0.getPath(), a1)) + ",\"") + "source") + "\":") + java_lang_String.marshall(a0.getSource(), a1)) + ",\"") + "overview") + "\":") + org_guvnor_common_services_shared_metadata_model_Overview.marshall(a0.getOverview(), a1)) + ",\"") + "elapsedTime") + "\":") + java_lang_Long.marshall(a0.getElapsedTime(), a1)) + ",\"") + "currentModule") + "\":") + org_kie_workbench_common_services_shared_project_KieModule.marshall(a0.getCurrentModule(), a1)) + ",\"") + "currentModulePackages") + "\":") + java_util_Set.marshall(a0.getCurrentModulePackages(), a1)) + ",\"") + "dataObjectPaths") + "\":") + java_util_Map.marshall(a0.getDataObjectPaths(), a1)) + ",\"") + "annotationDefinitions") + "\":") + java_util_Map.marshall(a0.getAnnotationDefinitions(), a1)) + ",\"") + "propertyTypes") + "\":") + java_util_List.marshall(a0.getPropertyTypes(), a1)) + ",\"") + "errors") + "\":") + java_util_List.marshall(a0.getErrors(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_guvnor_common_services_shared_metadata_model_Overview == null) {
      org_guvnor_common_services_shared_metadata_model_Overview = Marshalling.getMarshaller(Overview.class);
    }
    if (org_kie_workbench_common_services_shared_project_KieModule == null) {
      org_kie_workbench_common_services_shared_project_KieModule = Marshalling.getMarshaller(KieModule.class);
    }
  }
}