package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.uberfire.backend.vfs.Path;

public class Marshaller_o_k_w_c_s_d_m_GenerationResult_1_Impl implements GeneratedMarshaller<GenerationResult> {
  private GenerationResult[] EMPTY_ARRAY = new GenerationResult[0];
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  private Marshaller<Map> java_util_Map = Marshalling.getMarshaller(Map.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public GenerationResult[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public GenerationResult demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(GenerationResult.class, objId);
    }
    GenerationResult entity = new GenerationResult();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "generationTime": entity.setGenerationTime(java_lang_Long.demarshall(objVal, a1));
        break;
        case "objectFingerPrints": a1.setAssumedMapKeyType("java.lang.String");
        a1.setAssumedMapValueType("java.lang.String");
        entity.setObjectFingerPrints(java_util_Map.demarshall(objVal, a1));
        a1.resetAssumedTypes();
        break;
        case "source": entity.setSource(java_lang_String.demarshall(objVal, a1));
        break;
        case "dataObject": entity.setDataObject((DataObject) ((ObjectMarshaller) java_lang_Object).demarshall(DataObject.class, objVal, a1));
        break;
        case "path": entity.setPath((Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "errors": a1.setAssumedElementType("org.kie.workbench.common.screens.datamodeller.model.DataModelerError");
        entity.setErrors(java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(GenerationResult a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datamodeller.model.GenerationResult") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "generationTime") + "\":") + java_lang_Long.marshall(a0.getGenerationTime(), a1)) + ",\"") + "objectFingerPrints") + "\":") + java_util_Map.marshall(a0.getObjectFingerPrints(), a1)) + ",\"") + "source") + "\":") + java_lang_String.marshall(a0.getSource(), a1)) + ",\"") + "dataObject") + "\":") + java_lang_Object.marshall(a0.getDataObject(), a1)) + ",\"") + "path") + "\":") + java_lang_Object.marshall(a0.getPath(), a1)) + ",\"") + "errors") + "\":") + java_util_List.marshall(a0.getErrors(), a1)) + "}");
  }

  private void lazyInit() {

  }
}