package org.jboss.errai.marshalling.client.api;

import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.screens.datasource.management.metadata.CatalogMetadata;

public class Marshaller_o_k_w_c_s_d_m_m_CatalogMetadata_1_Impl implements GeneratedMarshaller<CatalogMetadata> {
  private CatalogMetadata[] EMPTY_ARRAY = new CatalogMetadata[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public CatalogMetadata[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public CatalogMetadata demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(CatalogMetadata.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("catalogName"), a1);
    CatalogMetadata entity = new CatalogMetadata(c0);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(CatalogMetadata a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datasource.management.metadata.CatalogMetadata") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "catalogName") + "\":") + java_lang_String.marshall(a0.getCatalogName(), a1)) + "}");
  }

  private void lazyInit() {

  }
}