package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.common.services.project.model.Module;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDef;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDefEditorContent;

public class Marshaller_o_k_w_c_s_d_m_m_DataSourceDefEditorContent_1_Impl implements GeneratedMarshaller<DataSourceDefEditorContent> {
  private DataSourceDefEditorContent[] EMPTY_ARRAY = new DataSourceDefEditorContent[0];
  private Marshaller<DataSourceDef> org_kie_workbench_common_screens_datasource_management_model_DataSourceDef = null;
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public DataSourceDefEditorContent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public DataSourceDefEditorContent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DataSourceDefEditorContent.class, objId);
    }
    DataSourceDefEditorContent entity = new DataSourceDefEditorContent();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "def": entity.setDef(org_kie_workbench_common_screens_datasource_management_model_DataSourceDef.demarshall(objVal, a1));
        break;
        case "module": entity.setModule((Module) ((ObjectMarshaller) java_lang_Object).demarshall(Module.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DataSourceDefEditorContent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datasource.management.model.DataSourceDefEditorContent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "def") + "\":") + org_kie_workbench_common_screens_datasource_management_model_DataSourceDef.marshall(a0.getDef(), a1)) + ",\"") + "module") + "\":") + java_lang_Object.marshall(a0.getModule(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_screens_datasource_management_model_DataSourceDef == null) {
      org_kie_workbench_common_screens_datasource_management_model_DataSourceDef = Marshalling.getMarshaller(DataSourceDef.class);
    }
  }
}