package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDef;

public class Marshaller_o_k_w_c_s_d_m_m_DataSourceDef_1_Impl implements GeneratedMarshaller<DataSourceDef> {
  private DataSourceDef[] EMPTY_ARRAY = new DataSourceDef[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public DataSourceDef[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public DataSourceDef demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DataSourceDef.class, objId);
    }
    final String c2 = java_lang_String.demarshall(obj.get("connectionURL"), a1);
    final String c3 = java_lang_String.demarshall(obj.get("driverUuid"), a1);
    final String c4 = java_lang_String.demarshall(obj.get("user"), a1);
    final String c5 = java_lang_String.demarshall(obj.get("password"), a1);
    final String c0 = java_lang_String.demarshall(obj.get("uuid"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("name"), a1);
    DataSourceDef entity = new DataSourceDef(c0, c1, c2, c3, c4, c5);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "uuid": entity.setUuid(java_lang_String.demarshall(objVal, a1));
        break;
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DataSourceDef a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datasource.management.model.DataSourceDef") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "connectionURL") + "\":") + java_lang_String.marshall(a0.getConnectionURL(), a1)) + ",\"") + "driverUuid") + "\":") + java_lang_String.marshall(a0.getDriverUuid(), a1)) + ",\"") + "user") + "\":") + java_lang_String.marshall(a0.getUser(), a1)) + ",\"") + "password") + "\":") + java_lang_String.marshall(a0.getPassword(), a1)) + ",\"") + "uuid") + "\":") + java_lang_String.marshall(a0.getUuid(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + "}");
  }

  private void lazyInit() {

  }
}