package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.screens.datasource.management.metadata.DatabaseMetadata;
import org.kie.workbench.common.screens.datasource.management.metadata.DatabaseMetadata.DatabaseType;

public class Marshaller_o_k_w_c_s_d_m_m_DatabaseMetadata_1_Impl implements GeneratedMarshaller<DatabaseMetadata> {
  private DatabaseMetadata[] EMPTY_ARRAY = new DatabaseMetadata[0];
  private Marshaller<DatabaseType> org_kie_workbench_common_screens_datasource_management_metadata_DatabaseMetadata_erraiD_DatabaseType = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public DatabaseMetadata[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public DatabaseMetadata demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DatabaseMetadata.class, objId);
    }
    DatabaseMetadata entity = new DatabaseMetadata();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "databaseType": entity.setDatabaseType(objVal.isObject() != null ? Enum.valueOf(DatabaseType.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(DatabaseType.class, objVal.isString().stringValue()) : null);
        break;
        case "databaseProductName": entity.setDatabaseProductName(java_lang_String.demarshall(objVal, a1));
        break;
        case "databaseProductVersion": entity.setDatabaseProductVersion(java_lang_String.demarshall(objVal, a1));
        break;
        case "driverName": entity.setDriverName(java_lang_String.demarshall(objVal, a1));
        break;
        case "driverVersion": entity.setDriverVersion(java_lang_String.demarshall(objVal, a1));
        break;
        case "driverMajorVersion": entity.setDriverMajorVersion(java_lang_Integer.demarshall(objVal, a1));
        break;
        case "driverMinorVersion": entity.setDriverMinorVersion(java_lang_Integer.demarshall(objVal, a1));
        break;
        case "schemas": a1.setAssumedElementType("org.kie.workbench.common.screens.datasource.management.metadata.SchemaMetadata");
        entity.setSchemas(java_util_List.demarshall(objVal, a1));
        break;
        case "catalogs": a1.setAssumedElementType("org.kie.workbench.common.screens.datasource.management.metadata.CatalogMetadata");
        entity.setCatalogs(java_util_List.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DatabaseMetadata a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datasource.management.metadata.DatabaseMetadata") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((("" + ",\"") + "databaseType") + "\":") + (a0.getDatabaseType() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datasource.management.metadata.DatabaseMetadata$DatabaseType") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getDatabaseType().name()) + "\"}" : "null")) + ",\"") + "databaseProductName") + "\":") + java_lang_String.marshall(a0.getDatabaseProductName(), a1)) + ",\"") + "databaseProductVersion") + "\":") + java_lang_String.marshall(a0.getDatabaseProductVersion(), a1)) + ",\"") + "driverName") + "\":") + java_lang_String.marshall(a0.getDriverName(), a1)) + ",\"") + "driverVersion") + "\":") + java_lang_String.marshall(a0.getDriverVersion(), a1)) + ",\"") + "driverMajorVersion") + "\":") + java_lang_Integer.marshall(a0.getDriverMajorVersion(), a1)) + ",\"") + "driverMinorVersion") + "\":") + java_lang_Integer.marshall(a0.getDriverMinorVersion(), a1)) + ",\"") + "schemas") + "\":") + java_util_List.marshall(a0.getSchemas(), a1)) + ",\"") + "catalogs") + "\":") + java_util_List.marshall(a0.getCatalogs(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_screens_datasource_management_metadata_DatabaseMetadata_erraiD_DatabaseType == null) {
      org_kie_workbench_common_screens_datasource_management_metadata_DatabaseMetadata_erraiD_DatabaseType = Marshalling.getMarshaller(DatabaseType.class);
    }
  }
}