package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.screens.datasource.management.model.DriverDef;

public class Marshaller_o_k_w_c_s_d_m_m_DriverDef_1_Impl implements GeneratedMarshaller<DriverDef> {
  private DriverDef[] EMPTY_ARRAY = new DriverDef[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public DriverDef[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public DriverDef demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DriverDef.class, objId);
    }
    final String c2 = java_lang_String.demarshall(obj.get("groupId"), a1);
    final String c3 = java_lang_String.demarshall(obj.get("artifactId"), a1);
    final String c4 = java_lang_String.demarshall(obj.get("version"), a1);
    final String c5 = java_lang_String.demarshall(obj.get("driverClass"), a1);
    final String c0 = java_lang_String.demarshall(obj.get("uuid"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("name"), a1);
    DriverDef entity = new DriverDef(c0, c1, c2, c3, c4, c5);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "uuid": entity.setUuid(java_lang_String.demarshall(objVal, a1));
        break;
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DriverDef a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datasource.management.model.DriverDef") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "groupId") + "\":") + java_lang_String.marshall(a0.getGroupId(), a1)) + ",\"") + "artifactId") + "\":") + java_lang_String.marshall(a0.getArtifactId(), a1)) + ",\"") + "version") + "\":") + java_lang_String.marshall(a0.getVersion(), a1)) + ",\"") + "driverClass") + "\":") + java_lang_String.marshall(a0.getDriverClass(), a1)) + ",\"") + "uuid") + "\":") + java_lang_String.marshall(a0.getUuid(), a1)) + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + "}");
  }

  private void lazyInit() {

  }
}