package org.jboss.errai.marshalling.client.api;

import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.screens.datasource.management.metadata.SchemaMetadata;

public class Marshaller_o_k_w_c_s_d_m_m_SchemaMetadata_1_Impl implements GeneratedMarshaller<SchemaMetadata> {
  private SchemaMetadata[] EMPTY_ARRAY = new SchemaMetadata[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public SchemaMetadata[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public SchemaMetadata demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(SchemaMetadata.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("catalogName"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("schemaName"), a1);
    SchemaMetadata entity = new SchemaMetadata(c0, c1);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(SchemaMetadata a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datasource.management.metadata.SchemaMetadata") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "catalogName") + "\":") + java_lang_String.marshall(a0.getCatalogName(), a1)) + ",\"") + "schemaName") + "\":") + java_lang_String.marshall(a0.getSchemaName(), a1)) + "}");
  }

  private void lazyInit() {

  }
}