package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.screens.datasource.management.model.TestResult;

public class Marshaller_o_k_w_c_s_d_m_m_TestResult_1_Impl implements GeneratedMarshaller<TestResult> {
  private TestResult[] EMPTY_ARRAY = new TestResult[0];
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public TestResult[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public TestResult demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(TestResult.class, objId);
    }
    TestResult entity = new TestResult();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "testPassed": entity.setTestPassed(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "message": entity.setMessage(java_lang_String.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static boolean TestResult_boolean_testPassed(TestResult instance) /*-{
    return instance.@org.kie.workbench.common.screens.datasource.management.model.TestResult::testPassed;
  }-*/;

  native static void TestResult_boolean_testPassed(TestResult instance, boolean value) /*-{
    instance.@org.kie.workbench.common.screens.datasource.management.model.TestResult::testPassed = value;
  }-*/;

  public String marshall(TestResult a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datasource.management.model.TestResult") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "testPassed") + "\":") + java_lang_Boolean.marshall(TestResult_boolean_testPassed(a0), a1)) + ",\"") + "message") + "\":") + java_lang_String.marshall(a0.getMessage(), a1)) + "}");
  }

  private void lazyInit() {

  }
}