package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorEditorContent;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorModel;
import org.uberfire.backend.vfs.Path;

public class Marshaller_o_k_w_c_s_d_m_p_PersistenceDescriptorEditorContent_1_Impl implements GeneratedMarshaller<PersistenceDescriptorEditorContent> {
  private PersistenceDescriptorEditorContent[] EMPTY_ARRAY = new PersistenceDescriptorEditorContent[0];
  private Marshaller<PersistenceDescriptorModel> org_kie_workbench_common_screens_datamodeller_model_persistence_PersistenceDescriptorModel = null;
  private Marshaller<Overview> org_guvnor_common_services_shared_metadata_model_Overview = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public PersistenceDescriptorEditorContent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public PersistenceDescriptorEditorContent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(PersistenceDescriptorEditorContent.class, objId);
    }
    PersistenceDescriptorEditorContent entity = new PersistenceDescriptorEditorContent();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "descriptorModel": entity.setDescriptorModel(org_kie_workbench_common_screens_datamodeller_model_persistence_PersistenceDescriptorModel.demarshall(objVal, a1));
        break;
        case "overview": entity.setOverview(org_guvnor_common_services_shared_metadata_model_Overview.demarshall(objVal, a1));
        break;
        case "source": entity.setSource(java_lang_String.demarshall(objVal, a1));
        break;
        case "path": entity.setPath((Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, objVal, a1));
        break;
        case "created": entity.setCreated(java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  native static boolean PersistenceDescriptorEditorContent_boolean_created(PersistenceDescriptorEditorContent instance) /*-{
    return instance.@org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorEditorContent::created;
  }-*/;

  native static void PersistenceDescriptorEditorContent_boolean_created(PersistenceDescriptorEditorContent instance, boolean value) /*-{
    instance.@org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorEditorContent::created = value;
  }-*/;

  public String marshall(PersistenceDescriptorEditorContent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorEditorContent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "descriptorModel") + "\":") + org_kie_workbench_common_screens_datamodeller_model_persistence_PersistenceDescriptorModel.marshall(a0.getDescriptorModel(), a1)) + ",\"") + "overview") + "\":") + org_guvnor_common_services_shared_metadata_model_Overview.marshall(a0.getOverview(), a1)) + ",\"") + "source") + "\":") + java_lang_String.marshall(a0.getSource(), a1)) + ",\"") + "path") + "\":") + java_lang_Object.marshall(a0.getPath(), a1)) + ",\"") + "created") + "\":") + java_lang_Boolean.marshall(PersistenceDescriptorEditorContent_boolean_created(a0), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_screens_datamodeller_model_persistence_PersistenceDescriptorModel == null) {
      org_kie_workbench_common_screens_datamodeller_model_persistence_PersistenceDescriptorModel = Marshalling.getMarshaller(PersistenceDescriptorModel.class);
    }
    if (org_guvnor_common_services_shared_metadata_model_Overview == null) {
      org_guvnor_common_services_shared_metadata_model_Overview = Marshalling.getMarshaller(Overview.class);
    }
  }
}