package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorModel;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceUnitModel;

public class Marshaller_o_k_w_c_s_d_m_p_PersistenceDescriptorModel_1_Impl implements GeneratedMarshaller<PersistenceDescriptorModel> {
  private PersistenceDescriptorModel[] EMPTY_ARRAY = new PersistenceDescriptorModel[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<PersistenceUnitModel> org_kie_workbench_common_screens_datamodeller_model_persistence_PersistenceUnitModel = null;
  public PersistenceDescriptorModel[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public PersistenceDescriptorModel demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(PersistenceDescriptorModel.class, objId);
    }
    PersistenceDescriptorModel entity = new PersistenceDescriptorModel();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "version": entity.setVersion(java_lang_String.demarshall(objVal, a1));
        break;
        case "persistenceUnit": entity.setPersistenceUnit(org_kie_workbench_common_screens_datamodeller_model_persistence_PersistenceUnitModel.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(PersistenceDescriptorModel a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorModel") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "version") + "\":") + java_lang_String.marshall(a0.getVersion(), a1)) + ",\"") + "persistenceUnit") + "\":") + org_kie_workbench_common_screens_datamodeller_model_persistence_PersistenceUnitModel.marshall(a0.getPersistenceUnit(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_screens_datamodeller_model_persistence_PersistenceUnitModel == null) {
      org_kie_workbench_common_screens_datamodeller_model_persistence_PersistenceUnitModel = Marshalling.getMarshaller(PersistenceUnitModel.class);
    }
  }
}