package org.jboss.errai.marshalling.client.api;

import java.util.List;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.screens.datamodeller.model.persistence.CachingType;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceUnitModel;
import org.kie.workbench.common.screens.datamodeller.model.persistence.TransactionType;
import org.kie.workbench.common.screens.datamodeller.model.persistence.ValidationMode;

public class Marshaller_o_k_w_c_s_d_m_p_PersistenceUnitModel_1_Impl implements GeneratedMarshaller<PersistenceUnitModel> {
  private PersistenceUnitModel[] EMPTY_ARRAY = new PersistenceUnitModel[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<CachingType> org_kie_workbench_common_screens_datamodeller_model_persistence_CachingType = null;
  private Marshaller<ValidationMode> org_kie_workbench_common_screens_datamodeller_model_persistence_ValidationMode = null;
  private Marshaller<TransactionType> org_kie_workbench_common_screens_datamodeller_model_persistence_TransactionType = null;
  public PersistenceUnitModel[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public PersistenceUnitModel demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(PersistenceUnitModel.class, objId);
    }
    PersistenceUnitModel entity = new PersistenceUnitModel();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": entity.setName(java_lang_String.demarshall(objVal, a1));
        break;
        case "description": entity.setDescription(java_lang_String.demarshall(objVal, a1));
        break;
        case "provider": entity.setProvider(java_lang_String.demarshall(objVal, a1));
        break;
        case "jtaDataSource": entity.setJtaDataSource(java_lang_String.demarshall(objVal, a1));
        break;
        case "nonJtaDataSource": entity.setNonJtaDataSource(java_lang_String.demarshall(objVal, a1));
        break;
        case "mappingFile": a1.setAssumedElementType("java.lang.String");
        entity.setMappingFile(java_util_List.demarshall(objVal, a1));
        break;
        case "jarFile": a1.setAssumedElementType("java.lang.String");
        entity.setJarFile(java_util_List.demarshall(objVal, a1));
        break;
        case "classes": a1.setAssumedElementType("org.kie.workbench.common.screens.datamodeller.model.persistence.PersistableDataObject");
        entity.setClasses(java_util_List.demarshall(objVal, a1));
        break;
        case "excludeUnlistedClasses": entity.setExcludeUnlistedClasses(java_lang_Boolean.demarshall(objVal, a1));
        break;
        case "sharedCacheMode": entity.setSharedCacheMode(objVal.isObject() != null ? Enum.valueOf(CachingType.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(CachingType.class, objVal.isString().stringValue()) : null);
        break;
        case "validationMode": entity.setValidationMode(objVal.isObject() != null ? Enum.valueOf(ValidationMode.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(ValidationMode.class, objVal.isString().stringValue()) : null);
        break;
        case "properties": a1.setAssumedElementType("org.kie.workbench.common.screens.datamodeller.model.persistence.Property");
        entity.setProperties(java_util_List.demarshall(objVal, a1));
        break;
        case "transactionType": entity.setTransactionType(objVal.isObject() != null ? Enum.valueOf(TransactionType.class, objVal.isObject().get("^EnumStringValue").isString().stringValue()) : objVal.isString() != null ? Enum.valueOf(TransactionType.class, objVal.isString().stringValue()) : null);
        break;
      }
    }
    return entity;
  }

  public String marshall(PersistenceUnitModel a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceUnitModel") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((((((((((((((((((((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "description") + "\":") + java_lang_String.marshall(a0.getDescription(), a1)) + ",\"") + "provider") + "\":") + java_lang_String.marshall(a0.getProvider(), a1)) + ",\"") + "jtaDataSource") + "\":") + java_lang_String.marshall(a0.getJtaDataSource(), a1)) + ",\"") + "nonJtaDataSource") + "\":") + java_lang_String.marshall(a0.getNonJtaDataSource(), a1)) + ",\"") + "mappingFile") + "\":") + java_util_List.marshall(a0.getMappingFile(), a1)) + ",\"") + "jarFile") + "\":") + java_util_List.marshall(a0.getJarFile(), a1)) + ",\"") + "classes") + "\":") + java_util_List.marshall(a0.getClasses(), a1)) + ",\"") + "excludeUnlistedClasses") + "\":") + java_lang_Boolean.marshall(a0.getExcludeUnlistedClasses(), a1)) + ",\"") + "sharedCacheMode") + "\":") + (a0.getSharedCacheMode() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datamodeller.model.persistence.CachingType") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getSharedCacheMode().name()) + "\"}" : "null")) + ",\"") + "validationMode") + "\":") + (a0.getValidationMode() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datamodeller.model.persistence.ValidationMode") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getValidationMode().name()) + "\"}" : "null")) + ",\"") + "properties") + "\":") + java_util_List.marshall(a0.getProperties(), a1)) + ",\"") + "transactionType") + "\":") + (a0.getTransactionType() != null ? ((((((("{\"" + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.datamodeller.model.persistence.TransactionType") + "\",\"") + "^EnumStringValue") + "\":\"") + a0.getTransactionType().name()) + "\"}" : "null")) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_screens_datamodeller_model_persistence_CachingType == null) {
      org_kie_workbench_common_screens_datamodeller_model_persistence_CachingType = Marshalling.getMarshaller(CachingType.class);
    }
    if (org_kie_workbench_common_screens_datamodeller_model_persistence_ValidationMode == null) {
      org_kie_workbench_common_screens_datamodeller_model_persistence_ValidationMode = Marshalling.getMarshaller(ValidationMode.class);
    }
    if (org_kie_workbench_common_screens_datamodeller_model_persistence_TransactionType == null) {
      org_kie_workbench_common_screens_datamodeller_model_persistence_TransactionType = Marshalling.getMarshaller(TransactionType.class);
    }
  }
}