package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.screens.defaulteditor.service.DefaultEditorContent;

public class Marshaller_o_k_w_c_s_d_s_DefaultEditorContent_1_Impl implements GeneratedMarshaller<DefaultEditorContent> {
  private DefaultEditorContent[] EMPTY_ARRAY = new DefaultEditorContent[0];
  private Marshaller<Overview> org_guvnor_common_services_shared_metadata_model_Overview = null;
  public DefaultEditorContent[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public DefaultEditorContent demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(DefaultEditorContent.class, objId);
    }
    DefaultEditorContent entity = new DefaultEditorContent();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "overview": entity.setOverview(org_guvnor_common_services_shared_metadata_model_Overview.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(DefaultEditorContent a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.defaulteditor.service.DefaultEditorContent") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "overview") + "\":") + org_guvnor_common_services_shared_metadata_model_Overview.marshall(a0.getOverview(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_guvnor_common_services_shared_metadata_model_Overview == null) {
      org_guvnor_common_services_shared_metadata_model_Overview = Marshalling.getMarshaller(Overview.class);
    }
  }
}