package org.jboss.errai.marshalling.client.api;

import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.screens.examples.model.Credentials;

public class Marshaller_o_k_w_c_s_e_m_Credentials_1_Impl implements GeneratedMarshaller<Credentials> {
  private Credentials[] EMPTY_ARRAY = new Credentials[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public Credentials[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public Credentials demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(Credentials.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("username"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("password"), a1);
    Credentials entity = new Credentials(c0, c1);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(Credentials a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.examples.model.Credentials") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "username") + "\":") + java_lang_String.marshall(a0.getUsername(), a1)) + ",\"") + "password") + "\":") + java_lang_String.marshall(a0.getPassword(), a1)) + "}");
  }

  private void lazyInit() {

  }
}