package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.screens.examples.model.Credentials;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;

public class Marshaller_o_k_w_c_s_e_m_ExampleRepository_1_Impl implements GeneratedMarshaller<ExampleRepository> {
  private ExampleRepository[] EMPTY_ARRAY = new ExampleRepository[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Credentials> org_kie_workbench_common_screens_examples_model_Credentials = null;
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public ExampleRepository[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static boolean ExampleRepository_boolean_isUrlValid(ExampleRepository instance) /*-{
    return instance.@org.kie.workbench.common.screens.examples.model.ExampleRepository::isUrlValid;
  }-*/;

  native static void ExampleRepository_boolean_isUrlValid(ExampleRepository instance, boolean value) /*-{
    instance.@org.kie.workbench.common.screens.examples.model.ExampleRepository::isUrlValid = value;
  }-*/;

  public ExampleRepository demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ExampleRepository.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("url"), a1);
    final Credentials c1 = org_kie_workbench_common_screens_examples_model_Credentials.demarshall(obj.get("credentials"), a1);
    ExampleRepository entity = new ExampleRepository(c0, c1);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "isUrlValid": ExampleRepository_boolean_isUrlValid(entity, java_lang_Boolean.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ExampleRepository a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.examples.model.ExampleRepository") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "url") + "\":") + java_lang_String.marshall(a0.getUrl(), a1)) + ",\"") + "credentials") + "\":") + org_kie_workbench_common_screens_examples_model_Credentials.marshall(a0.getCredentials(), a1)) + ",\"") + "isUrlValid") + "\":") + java_lang_Boolean.marshall(ExampleRepository_boolean_isUrlValid(a0), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_screens_examples_model_Credentials == null) {
      org_kie_workbench_common_screens_examples_model_Credentials = Marshalling.getMarshaller(Credentials.class);
    }
  }
}