package org.jboss.errai.marshalling.client.api;

import java.util.HashSet;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.screens.explorer.service.ActiveOptions;
import org.kie.workbench.common.screens.explorer.service.Option;

public class Marshaller_o_k_w_c_s_e_s_ActiveOptions_1_Impl implements GeneratedMarshaller<ActiveOptions> {
  private ActiveOptions[] EMPTY_ARRAY = new ActiveOptions[0];
  private Marshaller<HashSet> java_util_HashSet = null;
  public ActiveOptions[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static HashSet ActiveOptions_HashSet_set(ActiveOptions instance) /*-{
    return instance.@org.kie.workbench.common.screens.explorer.service.ActiveOptions::set;
  }-*/;

  native static void ActiveOptions_HashSet_set(ActiveOptions instance, HashSet<Option> value) /*-{
    instance.@org.kie.workbench.common.screens.explorer.service.ActiveOptions::set = value;
  }-*/;

  public ActiveOptions demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ActiveOptions.class, objId);
    }
    ActiveOptions entity = new ActiveOptions();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "set": a1.setAssumedElementType("org.kie.workbench.common.screens.explorer.service.Option");
        ActiveOptions_HashSet_set(entity, java_util_HashSet.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ActiveOptions a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.explorer.service.ActiveOptions") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "set") + "\":") + java_util_HashSet.marshall(ActiveOptions_HashSet_set(a0), a1)) + "}");
  }

  private void lazyInit() {
    if (java_util_HashSet == null) {
      java_util_HashSet = Marshalling.getMarshaller(HashSet.class);
    }
  }
}