package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.service.ActiveOptions;
import org.kie.workbench.common.screens.explorer.service.ProjectExplorerContentQuery;

public class Marshaller_o_k_w_c_s_e_s_ProjectExplorerContentQuery_1_Impl implements GeneratedMarshaller<ProjectExplorerContentQuery> {
  private ProjectExplorerContentQuery[] EMPTY_ARRAY = new ProjectExplorerContentQuery[0];
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  private Marshaller<Branch> org_guvnor_structure_repositories_Branch = null;
  private Marshaller<Package> org_guvnor_common_services_project_model_Package = null;
  private Marshaller<FolderItem> org_kie_workbench_common_screens_explorer_model_FolderItem = null;
  private Marshaller<ActiveOptions> org_kie_workbench_common_screens_explorer_service_ActiveOptions = null;
  public ProjectExplorerContentQuery[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static Repository ProjectExplorerContentQuery_Repository_repository(ProjectExplorerContentQuery instance) /*-{
    return instance.@org.kie.workbench.common.screens.explorer.service.ProjectExplorerContentQuery::repository;
  }-*/;

  native static void ProjectExplorerContentQuery_Repository_repository(ProjectExplorerContentQuery instance, Repository value) /*-{
    instance.@org.kie.workbench.common.screens.explorer.service.ProjectExplorerContentQuery::repository = value;
  }-*/;

  native static Branch ProjectExplorerContentQuery_Branch_branch(ProjectExplorerContentQuery instance) /*-{
    return instance.@org.kie.workbench.common.screens.explorer.service.ProjectExplorerContentQuery::branch;
  }-*/;

  native static void ProjectExplorerContentQuery_Branch_branch(ProjectExplorerContentQuery instance, Branch value) /*-{
    instance.@org.kie.workbench.common.screens.explorer.service.ProjectExplorerContentQuery::branch = value;
  }-*/;

  native static Module ProjectExplorerContentQuery_Module_module(ProjectExplorerContentQuery instance) /*-{
    return instance.@org.kie.workbench.common.screens.explorer.service.ProjectExplorerContentQuery::module;
  }-*/;

  native static void ProjectExplorerContentQuery_Module_module(ProjectExplorerContentQuery instance, Module value) /*-{
    instance.@org.kie.workbench.common.screens.explorer.service.ProjectExplorerContentQuery::module = value;
  }-*/;

  native static Package ProjectExplorerContentQuery_Package_pkg(ProjectExplorerContentQuery instance) /*-{
    return instance.@org.kie.workbench.common.screens.explorer.service.ProjectExplorerContentQuery::pkg;
  }-*/;

  native static void ProjectExplorerContentQuery_Package_pkg(ProjectExplorerContentQuery instance, Package value) /*-{
    instance.@org.kie.workbench.common.screens.explorer.service.ProjectExplorerContentQuery::pkg = value;
  }-*/;

  native static FolderItem ProjectExplorerContentQuery_FolderItem_item(ProjectExplorerContentQuery instance) /*-{
    return instance.@org.kie.workbench.common.screens.explorer.service.ProjectExplorerContentQuery::item;
  }-*/;

  native static void ProjectExplorerContentQuery_FolderItem_item(ProjectExplorerContentQuery instance, FolderItem value) /*-{
    instance.@org.kie.workbench.common.screens.explorer.service.ProjectExplorerContentQuery::item = value;
  }-*/;

  public ProjectExplorerContentQuery demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ProjectExplorerContentQuery.class, objId);
    }
    ProjectExplorerContentQuery entity = new ProjectExplorerContentQuery();
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "repository": ProjectExplorerContentQuery_Repository_repository(entity, (Repository) ((ObjectMarshaller) java_lang_Object).demarshall(Repository.class, objVal, a1));
        break;
        case "branch": ProjectExplorerContentQuery_Branch_branch(entity, org_guvnor_structure_repositories_Branch.demarshall(objVal, a1));
        break;
        case "module": ProjectExplorerContentQuery_Module_module(entity, (Module) ((ObjectMarshaller) java_lang_Object).demarshall(Module.class, objVal, a1));
        break;
        case "pkg": ProjectExplorerContentQuery_Package_pkg(entity, org_guvnor_common_services_project_model_Package.demarshall(objVal, a1));
        break;
        case "item": ProjectExplorerContentQuery_FolderItem_item(entity, org_kie_workbench_common_screens_explorer_model_FolderItem.demarshall(objVal, a1));
        break;
        case "options": entity.setOptions(org_kie_workbench_common_screens_explorer_service_ActiveOptions.demarshall(objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ProjectExplorerContentQuery a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.explorer.service.ProjectExplorerContentQuery") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((((((("" + ",\"") + "repository") + "\":") + java_lang_Object.marshall(a0.getRepository(), a1)) + ",\"") + "branch") + "\":") + org_guvnor_structure_repositories_Branch.marshall(a0.getBranch(), a1)) + ",\"") + "module") + "\":") + java_lang_Object.marshall(a0.getModule(), a1)) + ",\"") + "pkg") + "\":") + org_guvnor_common_services_project_model_Package.marshall(a0.getPkg(), a1)) + ",\"") + "item") + "\":") + org_kie_workbench_common_screens_explorer_model_FolderItem.marshall(a0.getItem(), a1)) + ",\"") + "options") + "\":") + org_kie_workbench_common_screens_explorer_service_ActiveOptions.marshall(a0.getOptions(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_guvnor_structure_repositories_Branch == null) {
      org_guvnor_structure_repositories_Branch = Marshalling.getMarshaller(Branch.class);
    }
    if (org_guvnor_common_services_project_model_Package == null) {
      org_guvnor_common_services_project_model_Package = Marshalling.getMarshaller(Package.class);
    }
    if (org_kie_workbench_common_screens_explorer_model_FolderItem == null) {
      org_kie_workbench_common_screens_explorer_model_FolderItem = Marshalling.getMarshaller(FolderItem.class);
    }
    if (org_kie_workbench_common_screens_explorer_service_ActiveOptions == null) {
      org_kie_workbench_common_screens_explorer_service_ActiveOptions = Marshalling.getMarshaller(ActiveOptions.class);
    }
  }
}