package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.forms.dynamic.service.shared.FormRenderingContext;
import org.kie.workbench.common.stunner.forms.context.PathAwareFormContext;
import org.uberfire.backend.vfs.Path;

public class Marshaller_o_k_w_c_s_f_c_PathAwareFormContext_1_Impl implements GeneratedMarshaller<PathAwareFormContext> {
  private PathAwareFormContext[] EMPTY_ARRAY = new PathAwareFormContext[0];
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public PathAwareFormContext[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static FormRenderingContext PathAwareFormContext_FormRenderingContext_wrapped(PathAwareFormContext instance) /*-{
    return instance.@org.kie.workbench.common.stunner.forms.context.PathAwareFormContext::wrapped;
  }-*/;

  native static void PathAwareFormContext_FormRenderingContext_wrapped(PathAwareFormContext instance, FormRenderingContext value) /*-{
    instance.@org.kie.workbench.common.stunner.forms.context.PathAwareFormContext::wrapped = value;
  }-*/;

  public PathAwareFormContext demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(PathAwareFormContext.class, objId);
    }
    final FormRenderingContext c0 = (FormRenderingContext) ((ObjectMarshaller) java_lang_Object).demarshall(FormRenderingContext.class, obj.get("wrapped"), a1);
    final Path c1 = (Path) ((ObjectMarshaller) java_lang_Object).demarshall(Path.class, obj.get("path"), a1);
    PathAwareFormContext entity = new PathAwareFormContext(c0, c1);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "wrapped": PathAwareFormContext_FormRenderingContext_wrapped(entity, (FormRenderingContext) ((ObjectMarshaller) java_lang_Object).demarshall(FormRenderingContext.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(PathAwareFormContext a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.forms.context.PathAwareFormContext") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((("" + ",\"") + "wrapped") + "\":") + java_lang_Object.marshall(PathAwareFormContext_FormRenderingContext_wrapped(a0), a1)) + ",\"") + "path") + "\":") + java_lang_Object.marshall(a0.getPath(), a1)) + "}");
  }

  private void lazyInit() {

  }
}