package org.jboss.errai.marshalling.client.api;

import java.util.Date;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.library.api.AssetInfo;

public class Marshaller_o_k_w_c_s_l_a_AssetInfo_1_Impl implements GeneratedMarshaller<AssetInfo> {
  private AssetInfo[] EMPTY_ARRAY = new AssetInfo[0];
  private Marshaller<FolderItem> org_kie_workbench_common_screens_explorer_model_FolderItem = null;
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  public AssetInfo[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public AssetInfo demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(AssetInfo.class, objId);
    }
    final FolderItem c0 = org_kie_workbench_common_screens_explorer_model_FolderItem.demarshall(obj.get("folderItem"), a1);
    final Date c1 = java_util_Date.demarshall(obj.get("lastModifiedTime"), a1);
    final Date c2 = java_util_Date.demarshall(obj.get("createdTime"), a1);
    AssetInfo entity = new AssetInfo(c0, c1, c2);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(AssetInfo a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.library.api.AssetInfo") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "folderItem") + "\":") + org_kie_workbench_common_screens_explorer_model_FolderItem.marshall(a0.getFolderItem(), a1)) + ",\"") + "lastModifiedTime") + "\":") + java_util_Date.marshall(a0.getLastModifiedTime(), a1)) + ",\"") + "createdTime") + "\":") + java_util_Date.marshall(a0.getCreatedTime(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_kie_workbench_common_screens_explorer_model_FolderItem == null) {
      org_kie_workbench_common_screens_explorer_model_FolderItem = Marshalling.getMarshaller(FolderItem.class);
    }
  }
}