package org.jboss.errai.marshalling.client.api;

import java.util.List;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.screens.library.api.LibraryInfo;

public class Marshaller_o_k_w_c_s_l_a_LibraryInfo_1_Impl implements GeneratedMarshaller<LibraryInfo> {
  private LibraryInfo[] EMPTY_ARRAY = new LibraryInfo[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public LibraryInfo[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public LibraryInfo demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(LibraryInfo.class, objId);
    }
    a1.setAssumedElementType("org.guvnor.common.services.project.model.WorkspaceProject");
    final List c0 = java_util_List.demarshall(obj.get("projects"), a1);
    LibraryInfo entity = new LibraryInfo(c0);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(LibraryInfo a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.library.api.LibraryInfo") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((("" + ",\"") + "projects") + "\":") + java_util_List.marshall(a0.getProjects(), a1)) + "}");
  }

  private void lazyInit() {

  }
}