package org.jboss.errai.marshalling.client.api;

import java.util.List;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.kie.workbench.common.screens.library.api.ProjectAssetsQuery;

public class Marshaller_o_k_w_c_s_l_a_ProjectAssetsQuery_1_Impl implements GeneratedMarshaller<ProjectAssetsQuery> {
  private ProjectAssetsQuery[] EMPTY_ARRAY = new ProjectAssetsQuery[0];
  private Marshaller<WorkspaceProject> org_guvnor_common_services_project_model_WorkspaceProject = null;
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public ProjectAssetsQuery[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ProjectAssetsQuery demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ProjectAssetsQuery.class, objId);
    }
    final WorkspaceProject c0 = org_guvnor_common_services_project_model_WorkspaceProject.demarshall(obj.get("project"), a1);
    final Integer c2 = java_lang_Integer.demarshall(obj.get("startIndex"), a1);
    final Integer c3 = java_lang_Integer.demarshall(obj.get("amount"), a1);
    final String c1 = java_lang_String.demarshall(obj.get("filter"), a1);
    a1.setAssumedElementType("java.lang.String");
    final List c4 = java_util_List.demarshall(obj.get("extensions"), a1);
    ProjectAssetsQuery entity = new ProjectAssetsQuery(c0, c1, c2, c3, c4);
    a1.recordObject(objId, entity);
    return entity;
  }

  public String marshall(ProjectAssetsQuery a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.screens.library.api.ProjectAssetsQuery") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((((((((((("" + ",\"") + "project") + "\":") + org_guvnor_common_services_project_model_WorkspaceProject.marshall(a0.getProject(), a1)) + ",\"") + "startIndex") + "\":") + java_lang_Integer.marshall(a0.getStartIndex(), a1)) + ",\"") + "amount") + "\":") + java_lang_Integer.marshall(a0.getAmount(), a1)) + ",\"") + "filter") + "\":") + java_lang_String.marshall(a0.getFilter(), a1)) + ",\"") + "extensions") + "\":") + java_util_List.marshall(a0.getExtensions(), a1)) + "}");
  }

  private void lazyInit() {
    if (org_guvnor_common_services_project_model_WorkspaceProject == null) {
      org_guvnor_common_services_project_model_WorkspaceProject = Marshalling.getMarshaller(WorkspaceProject.class);
    }
  }
}