package org.jboss.errai.marshalling.client.api;

import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;
import org.jboss.errai.marshalling.client.marshallers.ObjectMarshaller;
import org.kie.workbench.common.stunner.core.diagram.AbstractDiagram;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.stunner.project.diagram.impl.ProjectDiagramImpl;

public class Marshaller_o_k_w_c_s_p_d_i_ProjectDiagramImpl_1_Impl implements GeneratedMarshaller<ProjectDiagramImpl> {
  private ProjectDiagramImpl[] EMPTY_ARRAY = new ProjectDiagramImpl[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller java_lang_Object = Marshalling.getMarshaller(Object.class);
  public ProjectDiagramImpl[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  native static String AbstractDiagram_String_name(AbstractDiagram instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.diagram.AbstractDiagram::name;
  }-*/;

  native static void AbstractDiagram_String_name(AbstractDiagram instance, String value) /*-{
    instance.@org.kie.workbench.common.stunner.core.diagram.AbstractDiagram::name = value;
  }-*/;

  native static ProjectMetadata AbstractDiagram_ProjectMetadata_metadata(AbstractDiagram instance) /*-{
    return instance.@org.kie.workbench.common.stunner.core.diagram.AbstractDiagram::metadata;
  }-*/;

  native static void AbstractDiagram_ProjectMetadata_metadata(AbstractDiagram instance, ProjectMetadata value) /*-{
    instance.@org.kie.workbench.common.stunner.core.diagram.AbstractDiagram::metadata = value;
  }-*/;

  public ProjectDiagramImpl demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ProjectDiagramImpl.class, objId);
    }
    final String c0 = java_lang_String.demarshall(obj.get("name"), a1);
    final ProjectMetadata c2 = (ProjectMetadata) ((ObjectMarshaller) java_lang_Object).demarshall(ProjectMetadata.class, obj.get("metadata"), a1);
    final Graph c1 = (Graph) ((ObjectMarshaller) java_lang_Object).demarshall(Graph.class, obj.get("graph"), a1);
    ProjectDiagramImpl entity = new ProjectDiagramImpl(c0, c1, c2);
    a1.recordObject(objId, entity);
    final Set<String> keys = obj.keySet();
    for (String key : keys) {
      if (key.equals("^EncodedType") || key.equals("^ObjectID")) {
        continue;
      }
      EJValue objVal = obj.getIfNotNull(key);
      if (objVal == null) {
        continue;
      }
      switch (key) {
        case "name": AbstractDiagram_String_name(entity, java_lang_String.demarshall(objVal, a1));
        break;
        case "metadata": AbstractDiagram_ProjectMetadata_metadata(entity, (ProjectMetadata) ((ObjectMarshaller) java_lang_Object).demarshall(ProjectMetadata.class, objVal, a1));
        break;
        case "graph": entity.setGraph((Graph) ((ObjectMarshaller) java_lang_Object).demarshall(Graph.class, objVal, a1));
        break;
      }
    }
    return entity;
  }

  public String marshall(ProjectDiagramImpl a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final String prefix = ((((((((("" + "{\"") + "^EncodedType") + "\":\"") + "org.kie.workbench.common.stunner.project.diagram.impl.ProjectDiagramImpl") + "\"") + ",\"") + "^ObjectID") + "\":\"") + a1.getObject(a0)) + "\"";
    if (ref) {
      return prefix + "}";
    }
    return prefix + ((((((((((((("" + ",\"") + "name") + "\":") + java_lang_String.marshall(a0.getName(), a1)) + ",\"") + "metadata") + "\":") + java_lang_Object.marshall(a0.getMetadata(), a1)) + ",\"") + "graph") + "\":") + java_lang_Object.marshall(a0.getGraph(), a1)) + "}");
  }

  private void lazyInit() {

  }
}